Call spMante_Estado_Civil('NEW', NULL, 'NEGOCIOS SEOR as CAUTIVO S.R.L.', '20124589654', 'LAS AMERICAS 142 - CHICLAYO', 1);

DROP PROCEDURE IF EXISTS spMante_Estado_Civil;
CREATE PROCEDURE spMante_Estado_Civil(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(100),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_estado_civil 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A';
    
    if varExiste > 0 then
      set varError = CONCAT('EL ESTADO CIVIL <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_estado_civil),0)+1 INTO varCodigo FROM _srh_estado_civil;
      INSERT INTO _srh_estado_civil (id_estado_civil, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_estado_civil 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_estado_civil <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('EL ESTADO CIVIL <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_estado_civil set
      nombre       = UPPER(varNombre),
      _date_update = NOW(),
      _user_update = varUsuario
      where id_estado_civil = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;