call spMante_Cuota_Compra_Familia('NEW', '2013', '12',2, , 2, '01', '0108', '010803', 5000, 500, 1);
DROP PROCEDURE IF EXISTS spMante_Cuota_Compra_Familia;
CREATE PROCEDURE spMante_Cuota_Compra_Familia(
  varOpcion     varchar(10),
  varAnio       varchar(4),
  varMes        varchar(2),
  varEmpresa    int, 
  varProveedor  int,
  varTipo       varchar(2),
  varFamilia    varchar(4),
  varSubFamilia varchar(6),
  varMonto      double,
  varCantidad   double,
  varUsuario    int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
  DECLARE varDEmp, varDPro, varDMes, varDTip, varDFam, varDSub varchar(80) default '';
  
  select nombre into varDEmp from _sv_empresa where id_empresa = varEmpresa;
  select nombre into varDPro from _sv_proveedor where id_proveedor = varProveedor;
  select nombre into varDTip from _sv_tipo where id_tipo = varTipo;
  select nombre into varDFam from _sv_familia where id_familia = varFamilia;
  select nombre into varDSub from _sv_sub_familia where id_sub_familia = varSubFamilia;
  select spFuncion_NombreMes(varMes) into varDMes;
  
  if varOpcion='NEW' then
    select count(*) INTO varExiste from _sv_cuota_compra_familia
    where id_anio       = varAnio
    and id_mes          = varMes
    and id_empresa      = varEmpresa
    and id_proveedor    = varProveedor
    and id_tipo         = varTipo
    and id_familia      = varFamilia
    and id_sub_familia  = varSubFamilia
    and _estado = 'A';
    
    if varExiste <= 0 then 
      INSERT INTO _sv_cuota_compra_familia (id_anio, id_mes, id_empresa, id_proveedor, id_tipo, id_familia, id_sub_familia, 
                  monto, cantidad, _date_create, _date_update, _user_create, _user_update) 
      values (varAnio, varMes, varEmpresa, varProveedor, varTipo, varFamilia, varSubFamilia, varMonto, varCantidad,
              NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('LA CUOTA PARA\n',
                            'Anio \t\t: ', varAnio, '\n',
                            'Mes \t\t: ', varMes, ' - ', UPPER(varDMes), '\n',
                            'Empresa \t: ', varEmpresa, ' - ', UPPER(varDEmp), '\n',
                            'Proveedor \t: ', varProveedor, ' - ', UPPER(varDPro), '\n',
                            'Tipo \t\t: ', varTipo, ' - ', UPPER(varDTip), '\n',
                            'Familia \t\t: ', varFamilia, ' - ', UPPER(varDFam), '\n',
                            'Sub Familia \t: ', varSubFamilia, ' - ', UPPER(varDSub), '\n',
                            'YA SE ENCUENTRA REGISTRADA EN EL SISTEMA'
                            );
    end if;
  else
    update _sv_cuota_compra_familia set
    monto     = varMonto,
    cantidad  = varCantidad,
    _date_update = NOW(),
    _user_update = varUsuario
    where id_anio       = varAnio
    and id_mes          = varMes
    and id_empresa      = varEmpresa
    and id_proveedor    = varProveedor
    and id_tipo         = varTipo
    and id_familia      = varFamilia
    and id_sub_familia  = varSubFamilia;
  end if;
  select varError;
END;
  