call spMante_Cambio_Devolver_Parcial(1, 19483, '130012', 1, 9, 1);

DROP PROCEDURE IF EXISTS spMante_Cambio_Devolver_Parcial;
CREATE PROCEDURE spMante_Cambio_Devolver_Parcial(  
  varLocal    int,
	varVenta    bigint,
  varProducto varchar(6),
  varCantidad double,
  varMotRech  int,
  varUsuario  int
  )
BEGIN 
  DECLARE varExiste int;
  
  -- Movimiento Ingreso por Devolucion de Mercaderia  
  insert into _sv_movimiento_almacen(id_movimiento, id_local, id_almacen, id_referencia, id_producto, cantidad, fecha,
                                     _date_create, _date_update, _user_create, _user_update)
  values ('107', varLocal, 1, varVenta, varProducto, varCantidad, NOW(), NOW(), NOW(), varUsuario, varUsuario),
         ('207', varLocal, 2, varVenta, varProducto, varCantidad, NOW(), NOW(), NOW(), varUsuario, varUsuario);
  
  -- Agregamos la Devolucion al Amacen Fisico
  update _sv_kardex 
  SET cantidad = cantidad + varCantidad,
  _date_update = NOW(),
  _user_update = varUsuario
  where id_almacen= 1 
  and id_local    = varLocal 
  and id_producto = varProducto;
  
  -- Descontamos la Devolucion al Amacen Averias
  update _sv_kardex 
  SET cantidad = cantidad - varCantidad,
  _date_update = NOW(),
  _user_update = varUsuario
  where id_almacen= 2 
  and id_local    = varLocal 
  and id_producto = varProducto;
  
  -- Restamos la Cantidad devuelta del Documento de Venta
  update _sv_venta_detalle
  set cantidad = cantidad - varCantidad,
  _date_update = NOW(),
  _user_update = varUsuario
  where id_venta  = varVenta
  and id_producto = varProducto;
  
  /*
  -- Actualizamos la Cantidad y el Monto en el Detalle
  update _sv_venta_detalle
  set total     = round(cantidad*precio,2),
      igv       = round(cantidad*precio*0.18,2),
      subtotal  = round(cantidad*precio/1.18,2)
  where id_venta  = varVenta
  and id_producto = varProducto;
  
  -- Actualizamos el monto de la Cabecera del Documento
  update _sv_venta
  set total             = (select sum(total) as total       from _sv_venta_detalle where id_venta = varVenta),
      igv               = (select sum(igv)   as igv         from _sv_venta_detalle where id_venta = varVenta),
      subtotal          = (select sum(subtotal) as subtotal from _sv_venta_detalle where id_venta = varVenta),
      id_motivo_rechazo = varMotRech,
      _user_update      = varUsuario,
      _date_update      = NOW()
  where id_venta        = varVenta;
  
  -- Actualizamos el monto de la venta en el Movimiento de la Cuenta
  update _sv_movimiento_cuenta_cxc 
  set monto         = (select sum(total) as total       from _sv_venta_detalle where id_venta = varVenta),
      _user_update  = varUsuario,
      _date_update  = NOW()
  where id_venta  = varVenta 
  and tipo_mov    = 'VEN';
  
  -- Actualizamos el Saldo del Documento
  update _sv_venta 
  set saldo = (select sum(case when tipo_mov='VEN' then monto else monto*-1 end) as SALDO 
              from _sv_movimiento_cuenta_cxc 
              where id_venta = varVenta
              and _estado = 'A')
  where id_venta = varVenta;
  */
END;


