<?php
include_once '../conexion.php';

// Obtener los datos combinados del cuerpo de la solicitud
$data = json_decode(file_get_contents("php://input"), true);



// Iniciar la transacción
mysqli_autocommit($conn, false);
// Variable para verificar el estado de la transacción
$transaccionExitosa = true;
$errorMensaje = "";

try {
    // Acceder a los valores individuales de los datos combinados
    $cNombre = $data['Nombre'];
    $cPsw = $data['Psw'];
    $cPerfil = $data['Perfil'];
    $nIdUsuario = $data['IdUsuario'];
    $cEmpresaId = $data['IdEmpresa'];
    $cPrincipal = $data['Principal']; 
    $cEstado = $data['Estado'];

    if ($cEstado == 'NUEVO') {

        // Ejemplo de inserción en la tabla productos
        $queryUsuario = "INSERT INTO usuarios(nombre, password, perfil, principal, empresa_id)
            VALUES('$cNombre', '$cPsw', '$cPerfil', '$cPrincipal', '$cEmpresa_Id')";

        $resultadoUsuario = mysqli_query($conn, $queryUsuario);
        if (!$resultadoUsuario) {
            throw new Exception(mysqli_error($conn));
        }

        // Obtener el ID del último registro insertado
        $IdUsuario = mysqli_insert_id($conn);
        
        // Ejemplo de inserción en la tabla sucursales_usuarios
        foreach ($data['sedes'] as $sedes_) {
            $cUduario_Id = $equivalencias_['usuario_id'];
            $cSede_Id = $equivalencias_['sucursal_id'];

            $querySedes = "INSERT INTO sede_usuario(usuario_id, sucursal_id, empresa_id) 
                VALUES('$cUduario_Id', '$cSede_Id', '$cEmpresaId')";
            
            $resultadoSedes = mysqli_query($conn, $querySedes);
            if (!$resultadoSedes) {
                throw new Exception(mysqli_error($conn));
            }
        }

    } elseif ($cEstado == 'MODIFICAR') { 
        $queryUpd_Sedes = "UPDATE sede_usuario  SET IUD = 'D' WHERE usuario_id  = $nIdUsuario";
        $resultadoUpd_Sedes = mysqli_query($conn, $queryUpd_Sedes);        
        if (!$resultadoUpd_Sedes) {
            throw new Exception(mysqli_error($conn));
        }
        
        $queryUpd_Usuario = "UPDATE usuarios SET nombre = '$cNombre', password = '$cPsw', perfil = '$cPerfil', 
          principal = '$cPrincipal'
        WHERE id = $nIdUsuario";
        
        $resultadoUpd_Usuario = mysqli_query($conn, $queryUpd_Usuario);        
        if (!$resultadoUpd_Usuario) {
            throw new Exception(mysqli_error($conn));
        }

        // Ejemplo de inserción en la tabla sucursales_usuarios
        foreach ($data['sedes'] as $sedes_) {
            $cUduario_Id = $sedes_['usuario_id'];
            $cSede_Id = $sedes_['sucursal_id'];

            $querySedes = "INSERT INTO sede_usuario(usuario_id, sucursal_id, empresa_id) 
                VALUES('$cUduario_Id', '$cSede_Id', '$cEmpresaId')";
            
            $resultadoSedes = mysqli_query($conn, $querySedes);
            if (!$resultadoSedes) {
                throw new Exception(mysqli_error($conn));
            }
        }

        //Elimina sucursales_usuario para Evitar la Duplicidad
        $queryDel_Sedes = "DELETE FROM sede_usuario WHERE usuario_id  = $nIdUsuario AND IUD = 'D'";
        $resultadoDel_Sedes = mysqli_query($conn, $queryDel_Sedes);        
        if (!$resultadoDel_Sedes) {
           throw new Exception(mysqli_error($conn));
        }

    }

    // Confirmar la transacción
    mysqli_commit($conn);
    
} catch (Exception $e) {
    // Revertir la transacción en caso de error
    mysqli_rollback($conn);
    $transaccionExitosa = false;
    $errorMensaje = $e->getMessage();
}

// Cerrar la conexión a la base de datos
mysqli_close($conn);

// Enviar una respuesta al cliente
if ($transaccionExitosa) {
    $response = array("ESTADO" => "00", "MENSAJE" => "Los datos se han guardado correctamente");
} else {
    $response = array("ESTADO" => "11", "MENSAJE" => "Error al guardar la información: " . $errorMensaje);
}
echo json_encode($response);

?>