<?php
require_once ('jpgraph/jpgraph.php');
require_once ('jpgraph/jpgraph_odo.php');
require_once ('jpgraph/jpgraph_iconplot.php');
// Create a new odometer graph (width=250, height=200 pixels)
$graph = new OdoGraph(570,550);

$graph->title->Set('Manual positioning');
$graph->title->SetColor('white');
$graph->title->SetFont(FF_ARIAL,FS_BOLD,20);

$odo = array();
$acaptions = array(
    'UNO','DOS','TRES','CUATRO','CINCO','SEIS','SIETE','OCHO','NUEVE','DIEZ'
);

for($i = 0; $i <= 9; $i++ ) {
    $odo[$i] =new Odometer();
    $odo[$i]->SetColor("lightyellow");
    $odo[$i]->needle->Set(75);
    $odo[$i]->needle->SetStyle(NEEDLE_STYLE_ENDARROW, NEEDLE_ARROW_ML);
    $odo[$i]->caption->SetFont(FF_FONT1,FS_BOLD);
    $odo[$i]->caption->Set('Proveedor: '.$acaptions[$i]);
	$odo[$i]->AddIndication(0,40,'red');
	$odo[$i]->AddIndication(40,60,'orange');
	$odo[$i]->AddIndication(60,80,'yellow');
	$odo[$i]->AddIndication(80,90,'green:0.7');
	$odo[$i]->AddIndication(90,100,'green:0.9');
}

$row1 = new LayoutHor( array($odo[0],$odo[1]) );
$row2 = new LayoutHor( array($odo[2],$odo[3]) );
$row3 = new LayoutHor( array($odo[4],$odo[5]) );
$row4 = new LayoutHor( array($odo[6],$odo[7]) );
$row5 = new LayoutHor( array($odo[8],$odo[9]) );
$col1 = new LayoutVert( array($row1,$row2,$row3,$row4,$row5) );

// Add the odometer to the graph
$graph->Add($col1);

//$icon = new IconPlot(IMAGEN,IZQUIERDO,SUPERIOR,TAMAÑO IMAGEN EN PORCENTAJE,30);
$icon = new IconPlot('images/logo.jpg',145,5,0.8,30);
$icon->SetAnchor('center','top');
$graph->Add($icon);

// ... and finally stroke and stream the image back to the browser
$graph->Stroke();
?> 