call spQuery_Trabajador_RRHH(NULL, NULL, NULL, 1, null, null);

DROP PROCEDURE IF EXISTS spQuery_Trabajador_RRHH;
CREATE PROCEDURE spQuery_Trabajador_RRHH(
	varCodigo   int,
	varNombre   varchar(80),
	varDirecc   varchar(80),
  varEstado   int,
  varField    varchar(60),
  varOrder    varchar(5)
)
BEGIN
  DECLARE varCadCod, varCadNom, varCadDir, varCadEst TEXT DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT '';
	if varCodigo <> '' and varCodigo is not null then
    set varCadCod = CONCAT(" and C.id_trabajador = ", varCodigo," ");
  end if;
	if varNombre <> '' and varNombre is not null then
    set varCadNom = CONCAT(" and concat(C.apellido_paterno, ' ', C.apellido_materno, ' ', C.nombre) like '%", varNombre,"%' ");
  end if;
  if varDirecc <> '' and varDirecc is not null then
    set varCadDir = CONCAT(" and C.direccion like '%", varDirecc,"%' ");
  end if;
  if varEstado <> '' and varEstado is not null then
    set varCadEst = CONCAT(" and C.id_estado_trabajador = ", varEstado," ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  SET @sql = CONCAT("select lpad(cast(C.id_trabajador as char),8,'0') AS CTRA, ",
                    "C.id_alternativo as CALT, ",
                    "concat(ifnull(C.apellido_paterno,''), ' ', ifnull(C.apellido_materno,''), ' ', ifnull(C.nombre,'')) AS TRABAJADOR, ",
                    "I.abrev as CDOC, C.nro_documento as DOCIDE, C.DIRECCION, ",
                    "C.sueldo_base_mensual as SUELDO_MES, C.sueldo_base_diario as SUELDO_DIA, C.porc_comision_venta as COMISION, ",
                    "C.TELEFONO1, C.TELEFONO2, C.CELULAR, C.RPM, C.RPC, C.NEXTEL, C.BREVETE, C.EMAIL, ",
                    "C.id_estado_trabajador as CEST, E.nombre as ESTADO, ",
                    "CASE WHEN estado='A' then 'ACTIVO' else 'INACTIVO' END AS STATUS, ",
                    "date_format(C._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(C._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_trabajador C ",
                    "inner join _sv_tipo_trabajador T ON C.id_tipo_trabajador = T.id_tipo_trabajador ",
                    "inner join _srh_tipo_doc_identidad I on C.id_tipo_doc_identidad = I.id_tipo_doc_identidad "
                    "inner join _srh_estado_trabajador E on C.id_estado_trabajador = E.id_estado_trabajador ",
                    "left join _sys_usuario UN ON C._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON C._user_update = UU.id_usuario ",
                    "where C._estado='A' ",
                    varCadCod, varCadNom, varCadDir, varCadEst,
                    varCadOrd);
                      
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;