call spQuery_Trabajador_Conceptos(9, 1, 1,NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Trabajador_Conceptos;
CREATE PROCEDURE spQuery_Trabajador_Conceptos(
	varPlanilla   int,
	varTrabajador int,
  varEmpresa    int,
  varField      varchar(60),
  varOrder      varchar(5)
)
BEGIN
  DECLARE varCadCod, varCadNom, varCadDir, varCadTip TEXT DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT '';
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  SET @sql = CONCAT("select C.id_tipo_concepto as CTIP, T.nombre as TIPO, ", 
                    "D.id_concepto as CCON, C.nombre as CONCEPTO, D.monto, D.observacion ",
                    "from _srh_planilla_detalle D ",
                    "inner join _srh_concepto_remunerativo C ON D.id_concepto = C.id_concepto ",
                    "inner join _srh_tipo_concepto T ON C.id_tipo_concepto = T.id_tipo_concepto ",
                    "where D.id_planilla = ", varPlanilla," ",
                    "and D.id_trabajador = ", varTrabajador ," ",
                    "and D.id_empresa = ", varEmpresa, " ",
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;