call spQuery_Sistema_Menu_Usuario(2,1,8,'010201'); 

DROP PROCEDURE IF EXISTS spQuery_Sistema_Menu_Usuario;
CREATE PROCEDURE spQuery_Sistema_Menu_Usuario(
	varSistema  int,
  varUsuario  int,
  varNivel    int,
  varPadre    varchar(10)
)
BEGIN
  DECLARE varRol int;  
  select id_rol into varRol from _sys_usuario_sistema_rol where id_usuario=varUsuario and id_sistema=varSistema;
  
  if varNivel = 2 then
    select RM.id_menu, M.nombre, img_out, img_over, link 
    from _sys_rol_menu RM
    inner join _sys_menu M ON RM.id_sistema = M.id_sistema and RM.id_menu = M.id_menu
    where RM.id_rol   = varRol
    and M.id_sistema  = varSistema
    and M._estado     = 'A'
    and LENGTH(RM.id_menu)=varNivel
    order by M.orden, M.nombre;
  elseif varNivel = 4 then
    select RM.id_menu, M.nombre, img_out, img_over, link 
    from _sys_rol_menu RM
    inner join _sys_menu M ON RM.id_sistema = M.id_sistema and RM.id_menu = M.id_menu
    where RM.id_rol   = varRol
    and M.id_sistema  = varSistema
    and M._estado     = 'A'
    and LENGTH(RM.id_menu)        = varNivel
    and SUBSTRING(RM.id_menu,1,2) = varPadre
    order by M.orden, M.nombre;
  elseif varNivel = 6 then
    select RM.id_menu, M.nombre, img_out, img_over, link 
    from _sys_rol_menu RM
    inner join _sys_menu M ON RM.id_sistema = M.id_sistema and RM.id_menu = M.id_menu
    where RM.id_rol     = varRol
    and M.id_sistema    = varSistema
    and M._estado       = 'A'
    and LENGTH(RM.id_menu)        = varNivel
    and SUBSTRING(RM.id_menu,1,4) = varPadre
    order by M.orden, M.nombre;
  elseif varNivel = 8 then
    select RM.id_menu, M.nombre, img_out, img_over, link 
    from _sys_rol_menu RM
    inner join _sys_menu M ON RM.id_sistema = M.id_sistema and RM.id_menu = M.id_menu
    where RM.id_rol     = varRol
    and M.id_sistema    = varSistema
    and M._estado       = 'A'
    and LENGTH(RM.id_menu)        = varNivel
    and SUBSTRING(RM.id_menu,1,6) = varPadre
    order by M.orden, M.nombre;
  end if;
END;