call spQuery_Report_AnalCompDia_Vendedor(1, NULL, '2012', '02', 'T');

DROP PROCEDURE IF EXISTS spQuery_Report_AnalCompDia_Vendedor;
CREATE PROCEDURE spQuery_Report_AnalCompDia_Vendedor(
  varEmpresa    int,
  varProveedor  int,
	varAnio       varchar(4),
  varMes        varchar(2),
	varTipo       char(1)
)
BEGIN
  DECLARE varCadPro, varSQLCab, varSQLTipo  TEXT DEFAULT '';
  DECLARE varNumDia int;
  DECLARE varFechaIni, varFechaFin date;
  
  set varFechaIni = STR_TO_DATE(concat('01','.',lpad(varMes,2,'0'),'.',varAnio),'%d.%m.%Y');
  set varFechaFin = LAST_DAY(STR_TO_DATE(concat('01','.',varMes,'.',varAnio),'%d.%m.%Y'));   
  
  if varTipo = 'V' then
    set varSQLTipo = "D.subtotal";
  elseif varTipo = 'I' then
    set varSQLTipo = "D.igv";
  elseif varTipo = 'T' then
    set varSQLTipo = "D.total";
  end if;
  
  SET varNumDia = DAY(varFechaFin);
  SET @x = 1;
  REPEAT     
    SET varSQLCab = CONCAT(varSQLCab, "sum(case when day(V.fecha_emision)=", @x, "  then ", varSQLTipo, " end) as DIA_", LPAD(@x,2,'0'), ", ");
    SET @x = @x + 1; 
    UNTIL @x > varNumDia
  END REPEAT;
  
  if varProveedor <> '' and varProveedor <> 'Todos' and varProveedor is not null then
    SET varCadPro = CONCAT(" and P.id_proveedor = ", varProveedor, " ");
  end if;
  
  
  SET @sql = CONCAT("select V.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "Ve.id_cargo as CTIP, T.nombre as TIPO, ",
                    "V.id_trabajador as CVEN, CONCAT(Ve.apellido_paterno, ' ', Ve.apellido_materno, ' ', Ve.nombre) as VENDEDOR, ",
                    varSQLCab,
                    "sum(", varSQLTipo, ") as TOTAL " ,
                    "from _sv_venta_detalle D ",
                    "inner join _sv_venta V ON D.id_venta = V.id_venta ",
                    "inner join _sv_empresa E ON V.id_empresa = E.id_empresa ",
                    "inner join _sv_trabajador Ve ON V.id_trabajador = Ve.id_trabajador ",
                    "left join _sv_cargo T ON Ve.id_cargo = T.id_cargo ",
                    "where V._estado = 'A' ",
                    "and D._estado = 'A' ",
                    "and V.estado   <> 'AN' ",
                    "and YEAR(V.fecha_emision)  = '", varAnio, "' ",
                    "and MONTH(V.fecha_emision) = '", varMes, "' ",
                    "and V.id_empresa = ", varEmpresa, " ",
                    varCadPro,
                    "GROUP BY V.id_empresa, E.nombre, Ve.id_cargo, T.nombre, V.id_trabajador, CONCAT(Ve.apellido_paterno, ' ', Ve.apellido_materno, ' ', Ve.nombre)"); 
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1; 
END;