call spQuery_Report_AnalCompDia_Producto(1, NULL, '2011', '08', 'T');

DROP PROCEDURE IF EXISTS spQuery_Report_AnalCompDia_Producto;
CREATE PROCEDURE spQuery_Report_AnalCompDia_Producto(
  varEmpresa    int,
  varProveedor  int,
	varAnio       varchar(4),
  varMes        varchar(2),
	varTipo       char(1)
)
BEGIN
  DECLARE varSQLTipo, varSQLCab, varCadPro  TEXT DEFAULT '';
  DECLARE varNumDia int;
  DECLARE varFechaIni, varFechaFin date;
  
  set varFechaIni = STR_TO_DATE(concat('01','.',lpad(varMes,2,'0'),'.',varAnio),'%d.%m.%Y');
  set varFechaFin = LAST_DAY(STR_TO_DATE(concat('01','.',varMes,'.',varAnio),'%d.%m.%Y'));   
  
  if varTipo = 'V' then
    set varSQLTipo = "D.subtotal";
  elseif varTipo = 'I' then
    set varSQLTipo = "D.igv";
  elseif varTipo = 'T' then
    set varSQLTipo = "D.total";
  end if;
  
  SET varNumDia = DAY(varFechaFin);
  SET @x = 1;
  REPEAT     
    SET varSQLCab = CONCAT(varSQLCab, "sum(case when day(V.fecha_emision)=", @x, "  then ", varSQLTipo, " end) as DIA_", LPAD(@x,2,'0'), ", ");
    SET @x = @x + 1; 
    UNTIL @x > varNumDia
  END REPEAT;
  
  if varProveedor is not null then
    set varCadPro = CONCAT(" and P.id_proveedor = ", varProveedor, " ");
  end if;
  
  SET @sql = CONCAT("select V.id_empresa as CEMP, E.nombre as EMPRESA, "
                    "P.id_proveedor as CPRV, R.nombre as PROVEEDOR, ",
                    "D.id_producto as CPRO, P.descripcion as PRODUCTO, ",
                    varSQLCab,
                    "sum(", varSQLTipo, ") as TOTAL " ,
                    "from _sv_venta_detalle D ",
                    "inner join _sv_venta V     ON D.id_venta = V.id_venta ",
                    "inner join _sv_empresa E   ON V.id_empresa = E.id_empresa ",
                    "inner join _sv_producto P  ON D.id_producto = P.id_producto ",
                    "inner join _sv_proveedor R ON P.id_proveedor = R.id_proveedor ",
                    "where V._estado = 'A' ",
                    "and V.estado   <> 'AN' ",
                    "and YEAR(V.fecha_emision) = '", varAnio, "' ",
                    "and MONTH(V.fecha_emision) = '", varMes, "' ",
                    "and V.id_empresa = ", varEmpresa, " ",
                    varCadPro,
                    "GROUP BY V.id_empresa, E.nombre, P.id_proveedor, R.nombre, D.id_producto, P.descripcion"); 
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1; 
END;