call spQuery_Producto_Sub_familia(NULL,'','01','','FECHA_CREADO',NULL);

DROP PROCEDURE IF EXISTS spQuery_Producto_Sub_familia;
CREATE PROCEDURE spQuery_Producto_Sub_familia(
  varCodigo   int,
	varNombre   varchar(60),
  varLinea    varchar(10),
  varFamilia  varchar(10),
  varField    varchar(60),
  varOrder    varchar(5)
  )
BEGIN
  DECLARE varCadCod, varCadNom, varCadLin, varCadFam  text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo is not null or varCodigo <> '' then
    set varCadCod = CONCAT(" and M.id_sub_familia = ", varCodigo, " ");
  end if;
  if varNombre is not null or varNombre <> '' then
    set varCadNom = CONCAT(" and M.nombre LIKE '%", varNombre, "%' ");
  end if;
  if varLinea is not null and varLinea <> '' and varLinea <> 'Ninguno' then
    set varCadLin = CONCAT(" and substring(M.id_familia,1,2) = '", varLinea, "' ");
  end if;
  if varFamilia is not null and varFamilia <> '' and varFamilia <> 'Ninguno' then
    set varCadFam = CONCAT(" and M.id_familia = '", varFamilia, "' ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
	set @sql = CONCAT("select M.id_sub_familia AS CSUB, M.nombre AS SUBFAMILIA, ",
                    "M.id_familia as CFAM, F.nombre as FAMILIA, ",
                    "F.id_tipo as CLIN, L.nombre as LINEA, ",
                    "date_format(M._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(M._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_sub_familia M ",
                    "inner join _sv_familia F ON M.id_familia = F.id_familia ",
                    "inner join _sv_tipo    L ON F.id_tipo = L.id_tipo ",
                    "inner join _sys_usuario UN ON M._user_create = UN.id_usuario ",
                    "inner join _sys_usuario UU ON M._user_update = UU.id_usuario ",
                    "where M._estado='A' and M.id_sub_familia <> 0 ",
	                  varCadCod, varCadNom, varCadLin, varCadFam,
                    varCadOrd);		
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;