select TE.id_trabajador as CTRA, CONCAT(T.apellido_paterno, ' ', T.apellido_materno, ' ', T.nombre) as TRABAJADOR,
IFNULL(TE.remuneracion_mensual,0) as BRUTO,
CASE WHEN TE.id_tipo_planilla=1 
     THEN (SELECT monto FROM _srh_rmv where vigencia = (select max(vigencia) from _srh_rmv where _estado='A'))
     ELSE 0
END as RMV,
CASE WHEN TE.id_tipo_planilla=1 AND TE.flag_asigfam = 'S'
     THEN (SELECT monto FROM _srh_rmv where vigencia = (select max(vigencia) from _srh_rmv where _estado='A'))*0.10
     ELSE 0
END as ASIGFAM,

IFNULL(TE.remuneracion_mensual,0) -
CASE WHEN TE.id_tipo_planilla=1 
     THEN (SELECT monto FROM _srh_rmv where vigencia = (select max(vigencia) from _srh_rmv where _estado='A'))
     ELSE 0
END -
CASE WHEN TE.id_tipo_planilla=1 AND TE.flag_asigfam = 'S'
     THEN (SELECT monto FROM _srh_rmv where vigencia = (select max(vigencia) from _srh_rmv where _estado='A'))*0.10
     ELSE 0
END as COMISIONES,

IFNULL(TE.remuneracion_mensual,0) - IFNULL(TE.condilab_bono,0) - IFNULL(TE.condilab_viatico,0) AS COMPUTABLE
from _srh_trabajador_empresa TE
inner join _sv_trabajador T on TE.id_trabajador = T.id_trabajador
where TE.id_estado_trabajador = 1
and TE.id_empresa = 1;

SELECT monto FROM _srh_rmv where vigencia = (select max(vigencia) from _srh_rmv where _estado='A');


select P.id_planilla as CPLA, P.nombre as PLANILLA,
P.id_periodo_pago as CPEP, PP.nombre as PERPAGO,
P.id_periodo_afp AS CPEA, PA.nombre as PERAFP,
P.id_tipo_periodicidad as CPER, PE.nombre as PERIODICIDAD,
P.id_tipo_planilla as CTIP, T.nombre as TIPO,
date_format(P.fecha_inicio,'%d/%m/%Y') as FINI,
date_format(P.fecha_fin,'%d/%m/%Y') as FFIN,
P.dias_trabajados as DIAS
from _srh_planilla P
inner join _srh_periodo_pago PP ON P.id_periodo_pago = PP.id_periodo_pago
inner join _srh_periodo_afp PA  ON P.id_periodo_afp = PA.id_periodo_afp
inner join _srh_tipo_periodicidad PE ON P.id_tipo_periodicidad = PE.id_tipo_periodicidad
inner join _srh_tipo_planilla T ON P.id_tipo_planilla = T.id_tipo_planilla


select TE.id_trabajador as CTRA, CONCAT(T.apellido_paterno, ' ', T.apellido_materno, ' ', T.nombre) as TRABAJADOR,
TE.id_area as CARE, A.nombre as AREA,
TE.id_cargo as CCAR, C.nombre as CARGO,
TE.remuneracion_mensual as BRUTO,
case when TE.flag_asigfam = 'S' then 'SI' else 'NO' end as ASIGFAM,
case when TE.flag_quinta = 'S' then 'SI' else 'NO' end as QUINTA,
case when TE.flag_retener = 'S' then 'SI' else 'NO' end as RETENER
from _srh_trabajador_empresa TE
inner join _sv_trabajador T ON TE.id_trabajador = T.id_trabajador
inner join _srh_cargo C ON TE.id_cargo = C.id_cargo
inner join _srh_area A ON TE.id_area = A.id_area
where TE._estado = 'A'
and TE.id_estado_trabajador = 1
and TE.id_empresa = 1
and TE.id_agencia = 1
and TE.id_tipo_planilla = 1;