call spQuery_Packing_Mercaderia_Cambios(1, '2013-01-01', '2013-01-24', NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Packing_Mercaderia_Cambios;
CREATE PROCEDURE spQuery_Packing_Mercaderia_Cambios(
  varEmpresa  int,
  varFechaIni date,
  varFechaFin date,
  varVendedor text,
  varRuta     text
  )
BEGIN
  DECLARE varCadVen, varCadRut TEXT DEFAULT '';
  
	if varVendedor <> '' AND varVendedor <> 'Todos' then
    set varCadVen = CONCAT(" and V.id_trabajador in ", varVendedor);
  end if;
  if varRuta <> '' and varRuta is not null then
    set varCadRut = CONCAT(" and V.id_ruta in ", varRuta," ");
  end if;
  
  SET @sql = CONCAT("SELECT V.id_trabajador as CVEN, CONCAT(Ve.apellido_paterno, ' ', Ve.apellido_materno, ' ', Ve.nombre) as VENDEDOR, ",                    
                    "V.id_cliente as CCLI, C.nombre as CLIENTE, C.DIRECCION, ",
                    "DATE_FORMAT(V.fecha_emision, '%d/%m/%Y') AS FEMI, T.abrev as CTIP, ",
                    "CONCAT(V.nro_serie, '-', V.nro_preimpreso) as NDOC, ",
                    "D.id_producto as CPRO, P.descripcion as PRODUCTO, D.id_um as UM, D.CANTIDAD, ",
                    "DATE_FORMAT(D.fecha_vencimiento, '%d/%m/%Y') AS FVEN, D.LOTE ",                    
                    "FROM _sv_venta_detalle D ",
                    "inner join _sv_venta V          ON D.id_venta     = V.id_venta ",
                    "inner join _sv_producto P       ON D.id_producto  = P.id_producto ",
                    "inner join _sv_cliente C        ON V.id_cliente   = C.id_cliente ",
                    "inner join _sv_tipo_doc_venta T ON V.id_tipo_doc  = T.id_tipo_doc ",
                    "inner join _sv_trabajador Ve    ON V.id_trabajador  = Ve.id_trabajador ",
                    "where V._estado = 'A' and D._estado = 'A' and V.estado <> 'AN' ",
                    "and V.id_tipo_doc   = 5 ",
                    "and V.id_empresa = ", varEmpresa, " ",
                    "and V.fecha_emision >= '", varFechaIni, "' ",
                    "and V.fecha_emision <= '", varFechaFin, "' ",
                    varCadVen, varCadRut,
                    "order by V.id_trabajador, C.nombre, CONCAT(V.nro_serie, '-', V.nro_preimpreso), P.descripcion;");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;