select * from _sv_fact_mov_almacen where nro_documento='035808' and FMOV='2010-08-04' and 

call spQuery_Mov_Almacen_Detalle('2010','08','09','0942','120','0320200001');

DROP PROCEDURE IF EXISTS spQuery_Mov_Almacen_Detalle;
CREATE PROCEDURE spQuery_Mov_Almacen_Detalle(
  varAnio       varchar(4),
  varMes        varchar(2),
  varCD         varchar(2),
  varAlmacen    varchar(5),
  varOperacion  varchar(3),
  varArticulo   varchar(10)
  )
BEGIN
  DECLARE varFechaIni DATE DEFAULT STR_TO_DATE(concat('01','.',lpad(varMes,2,'0'),'.',varAnio),'%d.%m.%Y');
  DECLARE varFechaFin DATE DEFAULT LAST_DAY(STR_TO_DATE(concat('01','.',varMes,'.',varAnio),'%d.%m.%Y'));
  
  select M.nro_documento as NDOC,
  DATE_FORMAT(M.FMOV,'%d/%m/%Y') as FMOV,
  DATE_FORMAT(M.FLIQ,'%d/%m/%Y') as FLIQ,
  M.id_articulo as CART, A.descripcion as ARTICULO,
  M.id_operacion as COPE, O.nombre as OPERACION,
  M.TOBS, 
  M.id_conductor as CCON, C.nombre as CONDUCTOR,
  M.id_vehiculo as CVEH, V.PLACA,
  round(ifnull(M.QTOTAL,0),0)*A.bot_paquete + (ifnull(M.QTOTAL,0) - round(ifnull(M.QTOTAL,0),0))*100 as QTOTAL
  from _sv_fact_mov_almacen M
  inner join _sv_articulo A ON M.id_articulo = A.id_articulo
  inner join _sv_tipo_operacion O ON M.id_operacion = O.id_operacion
  left join _sv_conductor C ON M.id_conductor = C.id_conductor
  left join _sv_vehiculo V ON M.id_vehiculo = V.id_vehiculo
  where M.id_cd = varCD
  and M.id_almacen = varAlmacen
  and M.id_articulo  = varArticulo
  and M.id_operacion = varOperacion
  and M.FMOV >= varFechaIni
  and M.FMOV <= varFechaFin;
END;
