CALL spQuery_Lista_Precios_Detalle('P',1,1, 1,'','');

DROP PROCEDURE IF EXISTS spQuery_Lista_Precios_Detalle;
CREATE PROCEDURE spQuery_Lista_Precios_Detalle(	
  varProSer     char(1),
  varEmpresa    int,
  varLista      int, 
  varProveedor  int,
  varField      varchar(60),
  varOrder      varchar(5)
  )
BEGIN
  DECLARE varCadOrd, varCadPro TEXT DEFAULT '';
  IF varProveedor IS NOT NULL THEN
    SET varCadPro = CONCAT("and P.id_proveedor = ", varProveedor, " ");
  END IF;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'LP._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'LP._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  set @sql = CONCAT("select LP.id_producto as CPRO, P.descripcion as PRODUCTO, LP.id_um as UM, LP.PRECIO, ",
                    "date_format(LP._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(LP._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_lista_producto LP ",
                    "inner join _sv_producto P  ON LP.id_producto = P.id_producto ",
                    "inner join _sv_tipo L      ON P.id_tipo = L.id_tipo ",
                    "left join _sys_usuario UN  ON LP._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU  ON LP._user_update = UU.id_usuario ",
                    "where LP._estado  = 'A' ",
                    "and P._estado = 'A' "
                    "and L.flag_proser = '", varProSer, "' ",
                    "and LP.id_lista   = ", varLista, " ",
                    "and LP.id_empresa = ", varEmpresa, " ",
                    varCadPro,
                    varCadOrd, ";");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;


select LP.id_producto, P.descripcion, P.id_um_venta, LP.precio
			from _sv_lista_producto LP 
			inner join _sv_producto P ON LP.id_producto = P.id_producto
			from _sv_lista_producto LP 
			where LP.id_empresa = 1 
			and LP.id_lista		= 1 
			and LP.id_producto	= '010002';