CALL spQuery_Efectividad_Vendedor(1, NULL,'2012-09-01','2012-09-06');

DROP PROCEDURE IF EXISTS spQuery_Efectividad_Vendedor;
CREATE PROCEDURE spQuery_Efectividad_Vendedor( 
  varEmpresa    int,
	varProveedor  int,
  varFechaIni   date,
	varFechaFin   date  
  )
BEGIN  
  DECLARE varCadPro TEXT default '';
  DECLARE varIgv  double default 1.18;
  
  if varProveedor <> '' and varProveedor <> 'Todos' and varProveedor is not null then
    SET varCadPro = CONCAT(" and P.id_proveedor = ", varProveedor, " ");
  end if;

  set @sql = CONCAT("SELECT CEMP, EMPRESA, CTIP, TIPO, CVEN, VENDEDOR, ",
                    "SOLES_PREVENTA, SOLES_VENTA, SOLES_RECHAZO, SOLES_PARCIAL, round(SOLES_VENTA/SOLES_PREVENTA*100,2) AS SOLES_EFECT, "
                    "PEDID_PREVENTA, PEDID_VENTA, PEDID_RECHAZO, PEDID_PARCIAL, round(PEDID_VENTA/PEDID_PREVENTA*100,2) AS PEDID_EFECT, ",
                    "PDV_PREVENTA, PDV_VENTA, PDV_RECHAZO, PDV_PARCIAL, round(PDV_VENTA/PDV_PREVENTA*100,2) AS PDV_EFECT ",
                    "FROM "
                    "  (",
                    "  select C.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "  V.id_tipo_trabajador as CTIP, T.nombre as TIPO, ",
                    "  C.id_trabajador as CVEN, CONCAT(V.apellido_paterno, ' ', V.apellido_materno, ' ', V.nombre) as VENDEDOR, ",
                    "  SUM(round(D.cantidad_ate*D.precio/1.18,2)) as SOLES_PREVENTA