call spQuery_Cliente(NULL, NULL, NULL, '1L11', '1L1101', 'SECUENCIA', 'ASC');

DROP PROCEDURE IF EXISTS spQuery_Cliente;
CREATE PROCEDURE spQuery_Cliente(
	varCodigo   varchar(10),
	varNombre   varchar(80),
	varDirecc   varchar(80),
  varRuta     varchar(10),
  varModulo   varchar(10),
  varField    varchar(60),
  varOrder    varchar(5)
)
BEGIN
  DECLARE varCadCod, varCadNom, varCadDir, varCadRut, varCadMod TEXT DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT " ORDER BY R.nombre, M.nombre, cast(lpad(C.SECUENCIA,5,'0') as char) ";
  
	if varCodigo <> '' and varCodigo is not null then
    set varCadCod = CONCAT(" and C.id_cliente = ", varCodigo," ");
  end if;
	if varNombre <> '' and varNombre is not null then
    set varCadNom = CONCAT(" and C.nombre like '%", varNombre,"%' ");
  end if;
  if varDirecc <> '' and varDirecc is not null then
    set varCadDir = CONCAT(" and C.direccion LIKE '%", varDirecc,"%' ");
  end if;
  if varRuta <> '' and varRuta is not null then
    set varCadRut = CONCAT(" and C.id_ruta = '", varRuta,"' ");
  end if;
  if varModulo <> '' and varModulo is not null then
    set varCadMod = CONCAT(" and C.id_modulo = '", varModulo,"' ");
  end if;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  SET @sql = CONCAT("select cast(lpad(C.id_cliente,6,'0') as char) as CCLI, ",
                    "cast(lpad(C.SECUENCIA,5,'0') as char) AS SECUENCIA, C.nombre as CLIENTE, ",
                    "CASE WHEN C.SEXO = 'F' THEN 'FEMENINO' ELSE 'MASCULINO' END AS SEXO, ",
                    "CASE C.estado_civil WHEN 'S' THEN 'SOLETERO' ",
                    "                    WHEN 'C' THEN 'CASADO' ",
                    "                    WHEN 'V' THEN 'VIUDO' ",
                    "                    WHEN 'D' THEN 'DIVORCIADO' ",
                    "                    WHEN 'Z' THEN 'CONVIVIENTE' ",
                    "                    ELSE 'OTRO' ",
                    "END AS ESTADO_CIVIL, ",
                    "date_format(C.fecha_nacimiento,'%d/%m/%Y') as FECHANAC, ",
                    "C.DNI, C.RUC, C.DIRECCION, C.REFERENCIA, ",
                    "C.id_ruta as CRUT, R.nombre as RUTA, ",
                    "CASE WHEN C.id_modulo IS NULL OR C.id_modulo = '0' then '000000' else C.id_modulo end as CMOD, ",
                    "CASE WHEN C.id_modulo IS NULL OR C.id_modulo = '0' then 'SIN MODULO' else M.nombre end as MODULO, ",
                    "C.id_ubigeo as CUBI, U.DEPARTAMENTO, U.PROVINCIA, U.DISTRITO, C.TELEFONO1, C.TELEFONO2, ",
                    "C.CELULAR, C.RPM, C.RPC, C.NEXTEL, ",
                    "date_format(C.ultima_compra,'%d/%m/%Y') AS ULTIMA_COMPRA, ",
                    "DATEDIFF(NOW(), C.ultima_compra) as DIAS_NO_COMPRA, ",
                    "CASE WHEN C.estado='A' THEN 'ACTIVO' ELSE 'INACTIVO' END AS ESTADO, ",
                    "date_format(C._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(C._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_cliente C ",
                    "left join _sv_ubigeo U ON C.id_pais = U.id_pais and C.id_ubigeo = U.id_ubigeo ",
                    "left join _sv_ruta R ON C.id_ruta = R.id_ruta ",
                    "left join _sv_modulo M ON C.id_modulo = M.id_modulo ",                    
                    "left join _sys_usuario UN ON C._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON C._user_update = UU.id_usuario ",
                    "where C._estado = 'A' ",
                    varCadCod, varCadNom, varCadDir, varCadRut, varCadMod,
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;
