call spQuery_Avance_Ventas_Proveedor(1, '2012', '12', NULL, '2013-01-01', '2013-01-31');

DROP PROCEDURE IF EXISTS spQuery_Avance_Ventas_Proveedor;
CREATE PROCEDURE spQuery_Avance_Ventas_Proveedor( 
  varEmpresa    int,
	varAnio       varchar(4),
  varMes        varchar(4),
  varVendedor   int,
  varFechaIni   date,
	varFechaFin   date  
  )
BEGIN
  DECLARE varDiaAcum, varDiaUtil, varDiaFalt  double;
  DECLARE varCadVendedor TEXT default '';
  
  if varVendedor is not null then
    SET varCadVendedor = CONCAT(" and C.id_trabajador = ", varVendedor, " ");
  end if;
  
  SET varDiaAcum = spFuncion_DiasAcumulados(varAnio, varMes);
  SET varDiaUtil = spFuncion_DiasUtiles(varAnio,varMes);
  SET varDiaFalt = if(varDiaUtil>=varDiaAcum,varDiaUtil - varDiaAcum,0);
  
  set @sql = CONCAT("select A.CPRO, A.PROVEEDOR, B.META, ROUND(VENTA,2) AS VENTA, ROUND(VENTA/META*100,2) AS PORC_AVANCE, ",
                    "ROUND(CASE WHEN IFNULL(B.META,0)>0 and  IFNULL(B.META,0)>IFNULL(VENTA,0) ",
                    "      THEN (IFNULL(B.META,0) - IFNULL(VENTA,0))/(", varDiaFalt , ") ",
                    "      ELSE 0 ",
                    "END,2) as NEC_DIARIA, ",
                    "round(CASE WHEN ",varDiaAcum, "<",varDiaUtil," THEN VENTA/", varDiaAcum, "*", varDiaUtil, " ELSE VENTA END,2) as TENDENCIA, ",
                    "round((CASE WHEN ",varDiaAcum, "<",varDiaUtil," THEN VENTA/", varDiaAcum, "*", varDiaUtil, " ELSE VENTA END)/META*100,2) AS PORC_TENDENCIA ",
                    "from ",
                    "  ( ",
                    "  select P.id_proveedor as CPRO, L.nombre as PROVEEDOR, ",
                    "  SUM(D.subtotal) as VENTA ",
                    "  from _sv_venta_detalle D ",
                    "  inner join _sv_venta C ON D.id_venta = C.id_venta ",
                    "  inner join _sv_producto P ON D.id_producto = P.id_producto ",
                    "  inner join _sv_proveedor L ON P.id_proveedor = L.id_proveedor ",
                    "  where C._estado = 'A' ",
                    "  and D._estado   = 'A' ",
                    "  and C.estado   <> 'AN' ",
                    "  and C.id_empresa        = ", varEmpresa, " ",
                    "  and C.fecha_emision    >= '", varFechaIni, "' ",
                    "  and C.fecha_emision    <= '", varFechaFin, "' ",
                    varCadVendedor,
                    "  GROUP BY P.id_proveedor, L.nombre ",
                    "  ) A ",
                    "left join ",
                    "  ( ",
                    "  select C.id_proveedor as CPRO, SUM(C.monto) as META ",
                    "  from _sv_cuota_venta_vendedor C ",
                    "  where C.id_anio = '", varAnio, "' ",
                    "  and C.id_mes    = '", varMes, "' ",
                    "  and C.id_empresa = ", varEmpresa, " ",
                    varCadVendedor,
                    "  GROUP BY C.id_proveedor ",
                    "  ) B ",
                    "on A.CPRO = B.CPRO; ");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;