CALL spQuery_Asignacion_Detalle(1);

DROP PROCEDURE IF EXISTS spQuery_Asignacion_Detalle;
CREATE PROCEDURE spQuery_Asignacion_Detalle(
  varAsignacion int
  )
BEGIN  
  select A.id_asignacion as ASIG,
  date_format(A.id_fecha,'%d/%m/%Y') as FECHA,
  A.id_vehiculo as CVEH, V.PLACA, V.descripcion AS VEHICULO, A.MONTO_VEHICULO,
  A.id_conductor as CCON, concat(C.apellido_paterno, ' ', C.apellido_materno, ' ', C.nombre) as CONDUCTOR, A.MONTO_CONDUCTOR,
  (select count(id_venta) from _sv_asignacion_venta V where V.id_asignacion = A.id_asignacion and V._estado='A') as NUM_DOC,
  (select SUM(IFNULL(V.monto_ped,0)) from _sv_asignacion_venta V where V.id_asignacion = A.id_asignacion and V._estado='A') as MON_DOC,
  date_format(A._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO,
  date_format(A._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI,
  UPPER(UN.usuario) as USER_CREADO,
  UPPER(UU.usuario) as USER_MODIFI
  from _sv_asignacion A            
  inner join _sv_vehiculo V ON A.id_vehiculo = V.id_vehiculo
  inner join _sv_trabajador C ON A.id_conductor = C.id_trabajador
  left join _sys_usuario UN ON A._user_create = UN.id_usuario
  left join _sys_usuario UU ON A._user_update = UU.id_usuario
  where A._estado = 'A'
  and A.id_asignacion = varAsignacion;
END;