call spMante_Universidad('NEW', NULL, 'UNIVERSIDAD NACIONAL DE BAGUA', '01', 1);

DROP PROCEDURE IF EXISTS spMante_Universidad;
CREATE PROCEDURE spMante_Universidad(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(100),
  varDepart   varchar(2),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_universidad 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  
    and _estado = 'A'
    and id_departamento = varDepart;
    
    if varExiste > 0 then
      set varError = CONCAT('LA UNIVERSIDAD <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_universidad),0)+1 INTO varCodigo FROM _srh_universidad;
      INSERT INTO _srh_universidad (id_universidad, id_departamento, nombre, abrev, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varDepart, UPPER(varNombre), NULL, NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_universidad 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_universidad <> varCodigo
    and id_departamento = varDepart;
    if varExiste > 0 then
      set varError = CONCAT('LA UNIVERSIDAD <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_universidad set
      nombre          = UPPER(varNombre),
      id_departamento = varDepart,
      _date_update    = NOW(),
      _user_update    = varUsuario
      where id_universidad = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;