DROP PROCEDURE IF EXISTS spMante_Tipo_Vendedor;
CREATE PROCEDURE spMante_Tipo_Vendedor(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(80),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sv_tipo_vendedor
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A';
    if varExiste <= 0 then 
      SELECT ifnull(max(id_tipo_vendedor),0)+1 INTO varCodigo FROM _sv_tipo_vendedor;
      INSERT INTO _sv_tipo_vendedor (id_tipo_vendedor, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL TIPO DE VENDEDOR ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	else
    select count(*) INTO varExiste
    from _sv_tipo_vendedor
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and id_tipo_vendedor <> varCodigo;
    if varExiste <= 0 then 
      update _sv_tipo_vendedor set
      nombre  = UPPER(varNombre), 
      _date_update = NOW(),
      _user_update = varUsuario
      where id_tipo_vendedor = varCodigo;
    else
      set varError = CONCAT('EL TIPO DE VENDEDOR ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	end if;
  select varError;
END;