call spMante_Sistema_Menu('EDIT', , '0501', '', '', 'Procesos', 'b_folder.png', 'b_folder_add.png', '#', 10, 1);

DROP PROCEDURE IF EXISTS spMante_Sistema_Menu;
CREATE PROCEDURE spMante_Sistema_Menu(
	varOpcion   varchar(10),
  varSistema  int,
	varCodigo   varchar(10),
  varNivel1   varchar(2),
  varNivel2   varchar(4),
	varNombre   varchar(80),
	varOut      varchar(50),	
	varOver     varchar(50),
	varLink     varchar(60),
  varOrden    int,
	varUsuario  int
)
BEGIN
  declare varLinkMenu varchar(10);
  
	if varOpcion='NEW' then
    IF varNivel1 is NULL or varNivel1='' THEN 
      select CAST(LPAD(ifnull(max(id_menu),0)+1,2,'0') AS CHAR) INTO varCodigo 
      from _sys_menu
      where length(id_menu) = 2
      and id_sistema = varSistema;
    ELSEIF varNivel2 is NULL or varNivel2='' THEN
      select CONCAT(varNivel1,CAST(LPAD(ifnull(max(substring(id_menu,3,2)),0)+1,2,'0') AS CHAR)) INTO varCodigo 
      from _sys_menu
      where length(id_menu) = 4
      AND SUBSTRING(id_menu,1,2) = varNivel1
      and id_sistema = varSistema;
    ELSE
      select CONCAT(varNivel2,CAST(LPAD(ifnull(max(substring(id_menu,5,2)),0)+1,2,'0') AS CHAR)) INTO varCodigo 
      from _sys_menu
      where length(id_menu) = 6
      AND SUBSTRING(id_menu,1,4) = varNivel2
      and id_sistema = varSistema;
    END IF;
		
    if length(varCodigo)=6 then
      set varLinkMenu = CONCAT(varCodigo,".php");
    else
      set varLinkMenu = "#";
    end if;
    
    if varLink = '' or varLink is null then
      set varLink = varLinkMenu;    
    end if;
    
    INSERT INTO _sys_menu (id_sistema, id_menu, nombre, img_out, img_over, link, orden, _date_create, _date_update, _user_create, _user_update) 
		values (varSistema, varCodigo, varNombre, varOut, varOver, varLink, varOrden, NOW(), NOW(), varUsuario, varUsuario);
	else
		update _sys_menu set
		nombre   = varNombre, 
		img_out  = varOut,
		img_over = varOver,
		link     = varLink,
    orden    = varOrden,
    _date_update  = NOW(),
		_user_update = varUsuario
		where id_menu = varCodigo
    and id_sistema = varSistema;
	end if;
END;
