call spMante_Repartidor('NEW', NULL, 'camion fuso', 0, 'tarjpro', 'sw8085', '1985', NULL, NULL, NULL, NULL, 1);
 
DROP PROCEDURE IF EXISTS spMante_Repartidor;
CREATE PROCEDURE spMante_Repartidor(
	varOpcion     varchar(10),
	varCodigo     int,
	varNombre     varchar(80),
	varDni        varchar(8),
  varTelefono   varchar(20),
  varCosto      double,
  varEstado     char(1),
	varUsuario    int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then    
    select count(*) INTO varExiste from _sv_repartidor 
    where _estado = 'A' 
    and (TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) or TRIM(UPPER(dni)) = TRIM(UPPER(varDni)));
    
    if varExiste <= 0 then 
      
      SELECT ifnull(max(id_repartidor),0)+1 INTO varCodigo FROM _sv_repartidor;    
      
      INSERT INTO _sv_repartidor (id_repartidor, nombre, dni, telefono, monto, estado,
                                _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), varDni,  varTelefono, varCosto, varEstado, 
              NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL REPARTIDOR ', varNombre, ' \nO EL DNI ', varDni, ' \nYA SE ENCUENTRA REGISTRADO');
    end if;    	
	else
    
    select count(*) INTO varExiste  from _sv_repartidor
    where _estado = 'A'  and id_repartidor <> varCodigo
    and (TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) or TRIM(UPPER(dni)) = TRIM(UPPER(varDni)));
    
    if varExiste <= 0 then 
      update _sv_repartidor set      
      nombre       = UPPER(varNombre),       
      dni          = varDni, 
      telefono     = varTelefono,
      monto        = varCosto,
      estado       = varEstado,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_repartidor = varCodigo;
    else
      set varError = CONCAT('EL REPARTIDOR ', varNombre, ' \nO EL DNI ', varDni, ' \nYA SE ENCUENTRA REGISTRADO');
    end if;		
	end if;
  SELECT varError;
END;