call spMante_Planilla_Adelanto('NEW', '10', '2', '0102', 2, 3, 150, NULL, 1);
call spMante_Planilla_Adelanto('NEW', 15, 26683144, NULL, 1, 3, 'P', 4, 0, 40, NULL, 1);

DROP PROCEDURE IF EXISTS spMante_Planilla_Adelanto;
CREATE PROCEDURE spMante_Planilla_Adelanto(
	varOpcion     varchar(10),
	varPlanilla   int,
  varTrabajador int,
  varAdelanto   int,
  varEmpresa    int,
  varAgencia    int,
  varTipo       char(1),
  varBase       double,
  varPeso       double,
  varMonto      double,
  varObserva    text,
  varUsuario    int
)
BEGIN
  DECLARE varBanco  varchar(2);
  DECLARE varCuenta varchar(30);
	DECLARE varArea, varCargo int;
  if varOpcion='NEW' then
    SELECT ifnull(max(id_adelanto),0)+1 
    INTO varAdelanto 
    FROM _srh_planilla_adelanto
    where id_planilla = varPlanilla
    and id_trabajador = varTrabajador
    and id_empresa    = varEmpresa;
    if varTipo = 'P' then
      set varMonto = round(varBase*varPeso/100,2);
    end if;
    
    select id_banco_pago, nro_cuenta_pago, id_area, id_cargo
    into varBanco, varCuenta, varArea, varCargo
    from _srh_trabajador_empresa 
    where id_trabajador  = varTrabajador
    and id_empresa       = varEmpresa
    and id_tipo_planilla = (select id_tipo_planilla 
                            from _srh_planilla 
                            where id_planilla = varPlanilla);
    
    INSERT INTO _srh_planilla_adelanto(id_planilla, id_trabajador, id_adelanto, id_empresa, id_agencia, 
                                       id_banco, id_area, id_cargo, tipo_calculo, base, peso, monto, observacion, nro_cuenta,
                                       _date_create, _date_update, _user_create, _user_update) 
    values (varPlanilla, varTrabajador, varAdelanto, varEmpresa, varAgencia, varBanco, varArea, varCargo, 
            varTipo, varBase, varPeso, varMonto, varObserva, varCuenta, NOW(),NOW(), varUsuario, varUsuario);
	else
    update _srh_planilla_adelanto
    set monto    = varMonto, 
    peso         = varPeso,
    base         = varBase,
    observacion  = varObserva,
    _date_update = NOW(),
    _user_update = varUsuario
    where id_planilla = varPlanilla
    and id_trabajador = id_trabajador
    and id_adelanto   = varAdelanto
    and id_empresa    = varEmpresa;
	end if;
END;