call spMante_Inventario_Cab('NEW',NULL,CONCAT('INVENTARIO AL ',DATE_FORMAT(NOW(),'%d/%m/%Y')), NOW(), CONCAT('INVENTARIO AL ',DATE_FORMAT(NOW(),'%d/%m/%Y')), 1);

DROP PROCEDURE IF EXISTS spMante_Inventario_Cab;
CREATE PROCEDURE spMante_Inventario_Cab(
	varOpcion     varchar(10),
	varCodigo     int,
  varNombre     varchar(80),
	varFecha      date,
  varDescrip    text,
  varUsuario    int
)
BEGIN
  if varOpcion='NEW' then    
    SELECT ifnull(max(id_inventario),0)+1 INTO varCodigo FROM _sv_inventario_cab;
    INSERT INTO _sv_inventario_cab (id_inventario, nombre, fecha, descripcion, 
                                    _date_create, _date_update, _user_create, _user_update) 
    VALUES (varCodigo, varNombre, varFecha, varDescrip, NOW(),NOW(), varUsuario, varUsuario);
	else    
    update _sv_inventario_cab set
    nombre        = varNombre,
    fecha         = varFecha, 
    descripcion   = varDescrip, 
    _date_update  = NOW(), 
    _user_update  = varUsuario
    where id_inventario = varCodigo;
  end if;
  select varCodigo;
END;