
DROP PROCEDURE IF EXISTS spMante_Factor_Conversion;
CREATE PROCEDURE spMante_Factor_Conversion(
	varOpcion   varchar(10),
	varOrigen   varchar(10),
	varDestino  varchar(10),
  varOperador varchar(5),
  varFactor   int,
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
  DECLARE varInversa  varchar(5);
  
  if varOperador = '*' then
    set varInversa = '/';
  else
    set varInversa = '*';
  end if;
  
	if varOpcion='NEW' then
    -- Comprobamos que el nombre no exista
    select count(*) INTO varExiste
    from _sv_factor_conv
    where _estado = 'A'
    and TRIM(UPPER(id_um_origen))  = TRIM(UPPER(varOrigen))
    and TRIM(UPPER(id_um_destino)) = TRIM(UPPER(varDestino));
    
    if varExiste > 0 then 
      set varError = CONCAT('EL FACTOR DE CONVERSION : ORIGEN <<', varOrigen, '>>  DESTINO <<', varDestino, '>> YA SE ENCUENTRA REGISTRADO\n');
    end if;
    
    if varError = 'OK' then
      -- insertamos el factor de conversion
      INSERT INTO _sv_factor_conv(id_um_origen, id_um_destino, operacion, factor, _date_create, _date_update, _user_create, _user_update)
      values (UPPER(varOrigen), UPPER(varDestino), varOperador, varFactor, NOW(), NOW(), varUsuario, varUsuario);
      -- insertamos la inversa del factor de conversion
      if varDestino != varOrigen then
        INSERT INTO _sv_factor_conv(id_um_origen, id_um_destino, operacion, factor, _date_create, _date_update, _user_create, _user_update)
        values (UPPER(varDestino), UPPER(varOrigen), varInversa, varFactor, NOW(), NOW(), varUsuario, varUsuario);
      end if;
    end if;
	else    
      update _sv_factor_conv 
      set operacion = varOperador,
      factor        = varFactor,
      _date_update  = NOW(),
      _user_update  = varUsuario
      where id_um_origen = varOrigen
      and id_um_destino  = varDestino;    
	end if;
  select varError;
END;