call spMante_DevengeRegimen('NEW', '02', 4, 0, 0, 13, 1);

DROP PROCEDURE IF EXISTS spMante_DevengeRegimen;
CREATE PROCEDURE spMante_DevengeRegimen(
	varOpcion   varchar(10),
	varRegimen  varchar(2),
  varPeriodo  int,	
  varComision double,
  varPrima    double,
  varFondo    double,
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    -- Verificamos si existe el Devenge
    select count(*) INTO varExiste  
    from _srh_devenge_regimen 
    where id_regimen   = varRegimen
    and id_periodo_afp = varPeriodo
    and _estado        = 'A';
    
    if varExiste > 0 then
      set varError = CONCAT('YA SE ENCUENTRAN ASIGNADAS COMISIONES PARA :\n', 
                            'REGIMEN : \t\t', varRegimen, ' - ',
                            UPPER((select nombre from _srh_regimen_pension where id_regimen=varRegimen)), 
                            'PERIODO : \t', varPeriodo, ' - ',
                            UPPER((select nombre from _srh_periodo_afp where id_periodo_afp=varPeriodo))
                            );
    end if;
    if varError = '' then 
      INSERT INTO _srh_devenge_regimen (id_regimen, id_periodo_afp, porc_comision, porc_prima, porc_fondo, 
                                        _date_create, _date_update, _user_create, _user_update) 
      values (varRegimen, varPeriodo, varComision, varPrima, varFondo, NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    set varError = 'OK';
    update _srh_devenge_regimen set
    porc_comision = varComision, 
    porc_prima    = varPrima, 
    porc_fondo    = varFondo,
    _date_update  = NOW(),
    _user_update  = varUsuario
    where id_periodo_afp = varPeriodo
    and id_regimen       = varRegimen;
    set varError = 'OK';
	end if;
  select varError;
END;