call spMante_Colegio('EDIT', '147', 'MANUEL ANTONIO MESONES MURO', '01', '10', 1);

DROP PROCEDURE IF EXISTS spMante_Colegio;
CREATE PROCEDURE spMante_Colegio(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(100),
  varDepart   varchar(2),
  varDepend   varchar(2),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_colegio 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  
    and _estado = 'A'
    and id_departamento = varDepart;
    
    if varExiste > 0 then
      set varError = CONCAT('EL COLEGIO <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_colegio),0)+1 INTO varCodigo FROM _srh_colegio;
      INSERT INTO _srh_colegio (id_colegio, id_departamento, id_dependencia, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varDepart, varDepend, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_colegio 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_colegio <> varCodigo
    and id_departamento = varDepart;
    if varExiste > 0 then
      set varError = CONCAT('EL COLEGIO <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_colegio set
      nombre          = UPPER(varNombre),
      id_departamento = varDepart,
      id_dependencia  = varDepend,
      _date_update    = NOW(),
      _user_update    = varUsuario
      where id_colegio = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;