call spMante_Cambio_Devolver_Total(19483, 10, 1);

DROP PROCEDURE IF EXISTS spMante_Cambio_Devolver_Total;
CREATE PROCEDURE spMante_Cambio_Devolver_Total(  
	varNumDoc   bigint,
  varMotRech  int,
  varUsuario  int
  )
BEGIN 
  Declare varExiste, varLocal int;
  Declare varCantidad   double;
  Declare varProducto   varchar(6);
  
  DECLARE done INT DEFAULT 0;
  DECLARE curDetDoc CURSOR FOR 
		      select id_producto, cantidad from _sv_venta_detalle where id_venta = varNumDoc;
  
	DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
  
  select count(id_venta) into varExiste from _sv_venta where id_venta= varNumDoc and estado <> 'AN';
  
  if varExiste > 0 then
    select id_local into varLocal from _sv_venta where id_venta = varNumDoc;
    
    /*Cambiamos a Estado ANULADO=AN el Documento Seleccionado*/
    update _sv_venta 
    set estado        = 'AN', 
    subtotal          = 0, 
    igv               = 0, 
    total             = 0, 
    saldo             = 0,
    id_motivo_rechazo = varMotRech,
    _date_update      = NOW(), 
    _user_update      = varUsuario 
    where id_venta    = varNumDoc;    
   
    /*
    -- Anulamos los Movimientos en el Almacen generados en la Venta
    update _sv_movimiento_almacen 
    set _estado         = 'X', 
    _date_update        = NOW(),
    _user_update        = varUsuario 
    where id_referencia = varNumDoc 
    and id_movimiento   IN ('201','102');
    
    -- Anulamos los Movimientos de la Cuenta Corriente del Cliente
    update _sv_movimiento_cuenta_cxc
    set _estado   = 'X', 
    _date_update  = NOW(), 
    _user_update  = varUsuario 
    where id_venta= varNumDoc;
    
    -- ELIMINAMOS LOS PAGOS DE LA TABLA PAGO
    update _sv_pago_cxc
    set _estado   = 'X',
    _date_update  = NOW(), 
    _user_update  = varUsuario
    where id_venta= varNumDoc;
    */
    OPEN curDetDoc;
    REPEAT
      FETCH curDetDoc INTO varProducto, varCantidad;
      IF NOT done THEN
        -- Actualizar Kardex de Almacen Fisico
        update _sv_kardex 
        SET cantidad  = cantidad + varCantidad,
        _date_update  = NOW(),
        _user_update  = varUsuario
        where id_almacen= 1 
        and id_local    = varLocal 
        and id_producto = varProducto;
        
        -- Actualizamos Kardex de Almacen de Averias
        update _sv_kardex 
        SET cantidad = cantidad - varCantidad,
        _date_update = NOW(),
        _user_update = varUsuario
        where id_almacen= 2 
        and id_local    = varLocal 
        and id_producto = varProducto;
        
        -- Insertamos Movimientos de Almacen
        insert into _sv_movimiento_almacen(id_movimiento, id_local, id_almacen, id_referencia, id_producto, cantidad, fecha,
                                     _date_create, _date_update, _user_create, _user_update)
        values ('107', varLocal, 1, varNumDoc, varProducto, varCantidad, NOW(), NOW(), NOW(), varUsuario, varUsuario),
               ('207', varLocal, 2, varNumDoc, varProducto, varCantidad, NOW(), NOW(), NOW(), varUsuario, varUsuario);
              
      END IF;
      UNTIL done END REPEAT;
    CLOSE curDetDoc;
    
    -- ELIMINAMOS LOS PRODUCTOS DEL DETALLE
    update _sv_venta_detalle
    set cantidad   = 0,
    _date_update   = NOW(),
    _user_update   = varUsuario
    where id_venta = varNumDoc;
  end if;
END;

