select spFuncion_DiasUtiles('2010','03');

DROP FUNCTION IF EXISTS spFuncion_DiasUtiles;
CREATE FUNCTION spFuncion_DiasUtiles (
	varAnio varchar(4), 
	varMes  varchar(2)
	) 
RETURNS int
BEGIN
	declare varFecha date;
	set varFecha = STR_TO_DATE(concat('01','.',varMes,'.',varAnio),'%d.%m.%Y'); 	
	return DATEDIFF(LAST_DAY(varFecha), varFecha) + 1 - 
				 (
				 select count(*) as feriados from _sv_festivo 
				 where id_fecha >= varFecha and id_fecha<=LAST_DAY(varFecha)
				 ); 
end;