call spQuery_Reservacion(NULL, 1, NULL, NULL, '2012-08-23', '2012-08-31', 'AN', NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Reservacion;
CREATE PROCEDURE spQuery_Reservacion(
	varReserva  int,
  varEmpresa  int,
  varCliente  int,
  varPersona  int,
  varFechaIni date,
  varFechaFin date,
  varEstado   varchar(2),
	varField    varchar(60),
  varOrder    varchar(5)
  )
BEGIN
  DECLARE varCadRes, varCadEmp, varCadCli, varCadPer, varCadIni, varCadFin, varCadFec, varCadEst TEXT DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT '';
  update _sh_reservacion set estado='VE' where estado='AC' and fecha_salida<NOW();
	if varReserva <> '' and varReserva is not null then
    set varCadRes = CONCAT(" and R.id_reservacion = ", varReserva," ");
  end if;
  if varEmpresa <> '' and varEmpresa is not null then
    set varCadEmp = CONCAT(" and R.id_empresa = ", varEmpresa," ");
  end if;
  if varCliente <> '' and varCliente is not null then
    set varCadCli = CONCAT(" and R.id_cliente = ", varCliente," ");
  end if;
  if varPersona <> '' and varPersona is not null then
    set varCadPer = CONCAT(" and R.id_trabajador = ", varPersona," ");
  end if;
  if varFechaIni <> '' and varFechaIni is not null then
    set varCadIni = CONCAT(" ('", varFechaIni, "' between R.fecha_ingreso and R.fecha_salida) ");
  end if;
  if varFechaFin <> '' and varFechaFin is not null then
    set varCadFin = CONCAT(" ('", varFechaFin, "' between R.fecha_ingreso and R.fecha_salida) ");
  end if;
  if varEstado <> '' and varEstado is not null then
    set varCadEst = CONCAT(" and R.estado = '", varEstado,"' ");
  end if;
  
  if varCadIni <> '' and varCadFin <> '' then
    set varCadFec = CONCAT(" and (", varCadIni, " or ", varCadFin, ")"); 
  elseif varCadIni <> '' then
    set varCadFec = CONCAT(" and ", varCadIni);
  elseif varCadFin <> '' then
    set varCadFec = CONCAT(" and ", varCadFin);
  end if;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  SET @sql = CONCAT("select R.id_reservacion as IDE, ",
                    "R.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "R.id_cliente as CCLI, C.nombre AS CLIENTE, C.DNI, ",
                    "R.id_trabajador AS CTRA, CONCAT(T.apellido_paterno,' ',T.apellido_materno,' ',T.nombre) AS TRABAJADOR, ",
                    "DATEDIFF(R.fecha_salida, R.fecha_ingreso) AS DIAS, ",
                    "DATE_FORMAT(R.fecha_ingreso,'%d/%m/%Y') AS FING, DATE_FORMAT(R.fecha_salida,'%d/%m/%Y') AS FSAL, ",
                    "CASE R.estado WHEN 'AC' THEN 'ACTIVA' ",
                    "              WHEN 'AN' THEN 'ANULADA' ",
                    "              WHEN 'CO' THEN 'CONFIRMADA' ",
                    "              WHEN 'VE' THEN 'VENCIDA' ",
                    "              ELSE 'OTRO' ",
                    "END AS ESTADO, ",
                    "R.cant_adultos as ADULTOS, R.cant_ninos as NINOS, ",
                    "(select count(*) from _sh_reservacion_habitacion RH WHERE RH.id_reservacion = R.id_reservacion and RH._estado='A') AS NUMHAB, ",
                    "(select sum(RH.precio)*DATEDIFF(R.fecha_salida, R.fecha_ingreso) from _sh_reservacion_habitacion RH WHERE RH.id_reservacion = R.id_reservacion and RH._estado='A') AS TOTAL, ",
                    "IFNULL((select sum(monto) from _sh_reservacion_acuenta RP WHERE RP.id_reservacion = R.id_reservacion and RP._estado='A'),0) AS ACUENTA, ",
                    "DATE_FORMAT(R._date_create,'%d/%m/%Y %h:%i:%s %p') AS REGISTRADO ",
                    "from _sh_reservacion R ",
                    "inner join _sv_empresa E ON R.id_empresa = E.id_empresa ",
                    "inner join _sv_cliente C ON R.id_cliente = C.id_cliente ",
                    "inner join _sv_trabajador T ON R.id_trabajador = T.id_trabajador ",
                    "where R._estado = 'A' ",
                    varCadRes, varCadEmp, varCadCli, varCadPer, varCadFec, varCadEst,
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;
SELECT DATEDIFF('2012-08-31','2012-08-23')