call spQuery_Registro_Guias(NULL, NULL, NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Registro_Guias;
CREATE PROCEDURE spQuery_Registro_Guias(  
	varCliente    int, 
  varVendedor   int,
	varFechaIni   date,
	varFechaFin   date
  )
BEGIN  
  DECLARE varCadFechaIni, varCadFechaFin, varCadCliente, varCadVendedor varchar(100) DEFAULT '';
  
  IF IFNULL(varCliente,0) <> 0 THEN
    SET varCadCliente = CONCAT(" and C.id_cliente = ", varCliente, " ");  
  END IF;
  
  IF IFNULL(varVendedor,0) <> 0 THEN
    SET varCadVendedor = CONCAT(" and C.id_vendedor = ", varVendedor, " ");  
  END IF;
  
  IF varFechaIni IS NOT NULL THEN
    SET varCadFechaIni = CONCAT(" and C.fecha_emision >= '", varFechaIni, "' ");
  END IF;
  
  IF varFechaFin IS NOT NULL THEN
    SET varCadFechaFin = CONCAT(" and C.fecha_emision <= '", varFechaFin, "' ");
  END IF;
  set @sql = CONCAT("select C.id_guia as IDE, ",
                    "date_format(C.fecha_emision,'%d/%m/%Y') AS F_EMISION, ",
                    "date_format(C.fecha_traslado,'%d/%m/%Y') AS F_TRASLADO, ",
                    "CONCAT(T.abrev,' ', C.nro_documento) as DOCUMENTO, ",
                    "C.ESTADO, ",
                    "Tv.nombre as TIPO_REF, Ve.nro_documento as DOC_REF,",                    
                    "C.id_Cliente as CCLI, P.nombre as CLIENTE, ",
                    "C.id_vendedor as CVEN, V.nombre as VENDEDOR, ",              