call spQuery_Pagos_CxP(1, 0,NULL,NULL, NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Pagos_CxP;
CREATE PROCEDURE spQuery_Pagos_CxP(
  varEmpresa    int,
	varProveedor  int,
  varFechaIni   date,
	varFechaFin   date,
  varField  varchar(60),
  varOrder  varchar(5)
)
BEGIN
  DECLARE varCadOrd TEXT DEFAULT ' ORDER BY PROVEEDOR, FECHA';
  DECLARE varCadEmp, varCadPro, varCadIni, varCadFin TEXT DEFAULT '';
  
  IF varEmpresa IS NOT NULL THEN
    SET varCadEmp = CONCAT(" and P.id_empresa = '", varEmpresa, "' ");
  END IF;
  IF varProveedor is not null THEN
    SET varCadPro = CONCAT(" and P.id_proveedor = ", varProveedor);  
  END IF;
  IF varFechaIni IS NOT NULL THEN
    SET varCadIni = CONCAT(" and P.fecha >= '", varFechaIni, "' ");
  END IF;
  IF varFechaFin IS NOT NULL THEN
    SET varCadFin = CONCAT(" and P.fecha <= '", varFechaFin, "' ");
  END IF;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  SET @sql = CONCAT("select P.id_pago_cxp as CPAG, ",
                    "P.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "P.id_proveedor as CPRO, C.nombre as PROVEEDOR, ",
                    "CONCAT(T.abrev,' ', V.nro_documento) as DOCUMENTO, ",
                    "P.id_forma_pago as CTIP, TP.nombre as TIPO, P.nro_doc_pago as NPAGO, ",
                    "date_format(P.fecha,'%d/%m/%Y') as FECHA, P.MONTO, ",
                    "date_format(P._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(P._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_pago_cxp P ",
                    "inner join _sv_empresa E on P.id_empresa = E.id_empresa ",
                    "inner join _sv_forma_pago TP ON P.id_forma_pago = TP.id_forma_pago ",
                    "inner join _sv_proveedor C ON P.id_proveedor = C.id_proveedor ",
                    "inner join _sv_compra V On P.id_compra = V.id_compra ",
                    "inner join _sv_tipo_doc_compra T ON V.id_tipo_doc = T.id_tipo_doc ",
                    "left join _sys_usuario UN ON P._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON P._user_update = UU.id_usuario ",
                    "where P._estado = 'A' ",
                    varCadEmp, varCadPro, varCadIni, varCadFin,
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;

select * from _sv_pago_cxp