call spQuery_Logisitica_Inventario_Historico('T',1, 1, '2012-02-15','');

DROP PROCEDURE IF EXISTS spQuery_Logisitica_Inventario_Historico;
CREATE PROCEDURE spQuery_Logisitica_Inventario_Historico(
  varTipoProducto char(1),
  varEmpresa      int,
  varAlmacen      int,
  varFecha        date,
  varProveedor    int
  )
BEGIN
  DECLARE varCadTipoProd, varCadProveedor text default '';
  
  if varTipoProducto <> 'T' then
    set varCadTipoProd = CONCAT(" and K.cantidad   > 0 ");
  end if;
  
  if varProveedor <> '' and varProveedor is not null then
    set varCadProveedor = CONCAT(" and P.id_proveedor = ", varProveedor, " ");
  end if;
  
  
  SET @sql = CONCAT("select CLIN, LINEA, CTIP, TIPO, CFAM, FAMILIA, CSUB, SUB_FAMILIA, ",
                    "A.CPRO, PRODUCTO, UM, ",
                    "(select min(precio) from _sv_lista_producto L ",
                    " where L.id_lista  = 1 and L._estado='A' ",
                    " and L.id_producto = A.CPRO ",
                    " and L.id_um       = UM) AS PRECIO, ",
                    "STOCK_ACTUAL, ",
                    "ROUND(STOCK_ACTUAL*",
                    "IFNULL((select min(precio) from _sv_lista_producto L ",
                    " where L.id_lista  = 1 and L._estado='A' ",
                    " and L.id_producto = A.CPRO ",
                    " and L.id_um       = UM),0),2) AS VALORIZA_ACTUAL, ",
                    "STOCK_HISTO, ",                    
                    "ROUND(STOCK_HISTO*",
                    "IFNULL((select min(precio) from _sv_lista_producto L ",
                    " where L.id_lista  = 1 and L._estado='A' ",
                    " and L.id_producto = A.CPRO ",
                    " and L.id_um       = UM),0),2) AS VALORIZA_HISTO ",
                    "FROM ",
                    "  ( ",
                    "  select P.id_proveedor as CLIN, ",
                    "  L.nombre as LINEA, ",
                    "  P.id_tipo as CTIP, T.nombre as TIPO, ",
                    "  P.id_familia as CFAM, F.nombre as FAMILIA, ",
                    "  P.id_sub_familia as CSUB, S.nombre as SUB_FAMILIA, ",
                    "  P.id_producto as CPRO,  ",
                    "  P.descripcion as PRODUCTO, ",
                    "  P.id_um_stock as UM, ",
                    "  CASE WHEN K.cantidad<0 THEN 0 ELSE K.cantidad END as STOCK_ACTUAL ",
                    "  from _sv_kardex K ",
                    "  inner join _sv_producto P on K.id_producto = P.id_producto ",
                    "  inner join _sv_proveedor L on P.id_proveedor = L.id_proveedor ",
                    "  inner join _sv_tipo T    ON P.id_tipo = T.id_tipo ",
                    "  inner join _sv_familia F ON P.id_familia = F.id_familia ",
                    "  inner join _sv_sub_familia S ON P.id_sub_familia = S.id_sub_familia ",
                    "  Where P._estado  = 'A' ",
                    "  and K._estado    = 'A' ",
                    "  and K.id_empresa = ", varEmpresa, " ",
                    "  and K.id_almacen = ", varAlmacen, " ",
                    varCadTipoProd, varCadProveedor,
                    "  ) A ",
                    "LEFT JOIN ",
                    "  ( ",
                    "  select MA.id_producto as CPRO, ",
                    "  sum(case when T.tipo = 'SAL' then MA.cantidad*-1 ELSE MA.cantidad end) as STOCK_HISTO ",
                    "  from _sv_movimiento_almacen MA ",
                    "  inner join _sys_tipo_movimiento T ON MA.id_movimiento = T.id_movimiento ",
                    "  where MA._estado='A' ",
                    "  and MA.fecha <= '", varFecha, "' ",
                    "  and MA.id_empresa = ", varEmpresa, " ",
                    "  and MA.id_almacen = ", varAlmacen, " ",
                    "  group by MA.id_producto ",
                    "  ) B ",
                    "ON A.CPRO = B.CPRO ",
                    "ORDER BY LINEA, TIPO, FAMILIA, SUB_FAMILIA, PRODUCTO;");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;
