call spQuery_Indicador(NULL, 2, NULL, NULL, NULL, NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Indicador;
CREATE PROCEDURE spQuery_Indicador(
  varCodigo int,
  varNombre varchar(80),
  varUM     int,
  varTabla  int,
  varEstado char(1),
  varField  varchar(60),
  varOrder  varchar(5)
  )
BEGIN
  DECLARE varCadCod, varCadNom, varCadUme, varCadTab, varCadEst text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo is not null or varCodigo <> '' then
    set varCadCod = CONCAT(" and I.id_indicador = ", varCodigo, " ");
  end if;
  if ifnull(varNombre,'') <> '' then
    set varCadNom = CONCAT(" and I.nombre LIKE '%", varNombre, "%' ");
  end if;
  if ifnull(varUM,'') <> '' then
    set varCadUme = CONCAT(" and I.id_um = '", varUM, "' ");
  end if;
  if ifnull(varTabla,'') <> '' then
    set varCadTab = CONCAT(" and I.id_tabla = '", varTabla, "' ");
  end if;
  if ifnull(varEstado,'') <> '' then
    set varCadEst = CONCAT(" and I.estado = '", varEstado, "' ");
  end if;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'I._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'I._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
	set @sql = CONCAT("select I.id_indicador as CIND, I.nombre as INDICADOR, I.ABREV, ",
                    "I.id_um as CUM, U.nombre as UNIDMED, ",
                    "I.id_tabla as CTAB, T.nombre as TABLA, "
                    "I.DESCRIPCION, I.FORMU_CABECERA, I.FORMU_CONDICION, ",
                    "I.FORMU_LLEGARON, I.FORMU_FALTA, I.FORMU_UNIVERSO, I.ORDEN, ",
                    "(select count(distinct id_matriz) from _sind_matriz_detalle M where M._estado='A' and M.id_indicador = I.id_indicador) as MATRIZ, ",
                    "CASE WHEN I.estado='A' THEN 'ACTIVO' ELSE 'INACTIVO' END AS ESTADO, "
                    "date_format(I._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(I._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sind_indicador I ",
                    "inner join _sind_tabla T ON I.id_tabla = T.id_tabla ",
                    "inner join _sind_unidad_medida U ON I.id_um = U.id_um ",
                    "left join _sys_usuario UN ON I._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON I._user_update = UU.id_usuario ",
                    "where I._estado='A' ",
	                  varCadCod, varCadNom, varCadUme, varCadTab, varCadEst,
                    varCadOrd);		
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;

