call spQuery_Impresion_Documento(2, 2, 3, 6, 80, 100, '2014-01-09', '2014-01-13', 3);

DROP PROCEDURE IF EXISTS spQuery_Impresion_Documento;
CREATE PROCEDURE spQuery_Impresion_Documento( 
  varEmpresa  int,
  varAgencia  int,
  varPuntoVe  int,
  varSerie    int,
  varNumIni   int, 
  varNumFin   int,
  varFechaIni date,
  varFechaFin date,
  varTipoDoc  int
  )
BEGIN
  DECLARE varNumSerie varchar(5);
  
  select nro_serie
  into varNumSerie
  from _sv_serie_punto_venta S
  where S.id_empresa    = varEmpresa
  and S.id_punto_venta  = varPuntoVe
  and S.id_serie        = varSerie;
  
  select C.id_venta as IDE,
  C.id_empresa as CEMP, E.nombre AS EMPRESA, E.direccion AS DIRECCIONEMP, E.ruc AS RUCEMP,
  date_format(C.fecha_emision,'%d/%m/%Y') AS FECHA,
  C.id_tipo_doc as CTIP,
  T.nombre as TIPO,
  CONCAT(C.nro_serie,'-', C.nro_preimpreso) as DOCUMENTO,
  C.id_condicion as CCON, TC.nombre as CONDICION,
  C.ESTADO,
  C.id_cliente as CCLI, P.nombre as CLIENTE, P.DIRECCION, P.REFERENCIA,
  C.id_trabajador as CVEN, CONCAT(V.apellido_paterno,' ', V.apellido_materno,' ', V.nombre) as VENDEDOR,
  P.id_ruta as CRUT, R.nombre as RUTA,
  C.nro_pedido as PEDIDO, C.nro_guia as GUIA,
  C.TOTAL,
  date_format(C._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO,
  date_format(C._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI,
  UPPER(UN.usuario) as USER_CREADO,
  UPPER(UU.usuario) as USER_MODIFI
  from _sv_venta C
  inner join _sv_empresa E ON E.id_empresa = C.id_empresa
  inner join _sv_cliente P ON C.id_Cliente = P.id_Cliente
  inner join _sv_ruta R ON P.id_ruta = R.id_ruta
  inner join _sv_tipo_doc_venta T ON C.id_tipo_doc = T.id_tipo_doc
  inner join _sv_tipo_condicion TC ON C.id_condicion = TC.id_condicion
  inner join _sv_trabajador V ON C.id_trabajador = V.id_trabajador
  inner join _sys_usuario UN ON C._user_create = UN.id_usuario
  inner join _sys_usuario UU ON C._user_update = UU.id_usuario
  where C._estado='A'
  and C.id_tipo_doc     = varTipoDoc
  and C.id_empresa      = varEmpresa
  and C.id_agencia      = varAgencia
  and C.nro_serie       = lpad(varNumSerie,3,'0')
  and C.nro_preimpreso >= varNumIni
  and C.nro_preimpreso <= varNumFin
  and C.fecha_emision  >= varFechaIni
  and C.fecha_emision  <= varFechaFin
  order by C.id_venta;
  
END;