CALL spQuery_Efectividad_Rutas('1','1','','2011-09-01','2011-09-30');

DROP PROCEDURE IF EXISTS spQuery_Efectividad_Rutas;
CREATE PROCEDURE spQuery_Efectividad_Rutas( 
	varEmpresa    int,
  varVendedor   int,
  varProveedor  int,
  varFechaIni   date,
	varFechaFin   date  
  )
BEGIN  
  DECLARE varCadVen, varCadPro TEXT default '';
  DECLARE varIgv  double default 1.18;
  
  if varVendedor <> '' and varVendedor <> 'Todos' and varVendedor is not null then
    SET varCadVen = CONCAT(" and C.id_trabajador = ", varVendedor, " ");
  end if;
  
  if varProveedor <> '' and varProveedor <> 'Todos' and varProveedor is not null then
    SET varCadPro = CONCAT(" and P.id_proveedor = ", varProveedor, " ");
  end if;
  
  set @sql = CONCAT("SELECT CEMP, EMPRESA, CRUT, RUTA, ",
                    "SOLES_PREVENTA, SOLES_VENTA, SOLES_RECHAZO, SOLES_PARCIAL, SOLES_VENTA/SOLES_PREVENTA*100 AS SOLES_EFECT, "
                    "PEDID_PREVENTA, PEDID_VENTA, PEDID_RECHAZO, PEDID_PARCIAL, PEDID_VENTA/PEDID_PREVENTA*100 AS PEDID_EFECT, ",
                    "PDV_PREVENTA, PDV_VENTA, PDV_RECHAZO, PDV_PARCIAL, PDV_VENTA/PDV_PREVENTA*100 AS PDV_EFECT ",
                    "FROM "
                    "  (",
                    "  select C.id_empresa as CEMP, E.nombre as EMPRESA, C.id_ruta as CRUT, R.nombre as RUTA, ",
                    "  SUM(round(D.cantidad_ate*D.precio/1.18,2)) as SOLES_PREVENTA, ",
     