DROP PROCEDURE IF EXISTS spQuery_Boleta_Pago_Detalle;
CREATE PROCEDURE spQuery_Boleta_Pago_Detalle(
  varPlanilla   int,
	varEmpresa    int,
  varTrabajador int,
  varTipo       char(1)
  )
BEGIN
  select TIPO, CCON, CONCEPTO, MONTO
  FROM
  (
    select T.TIPO, 
    CASE WHEN IFNULL(C.agrupa_boleta,'')<>''
        THEN C.agrupa_boleta
        ELSE PD.id_concepto 
    END as CCON, 
    CASE WHEN IFNULL(C.agrupa_boleta,'')<>''
        THEN B.nombre
        ELSE C.nombre
    END as CONCEPTO,
    SUM(PD.monto) AS MONTO
    from _srh_planilla_detalle PD
    inner join _srh_concepto_remunerativo C ON PD.id_concepto = C.id_concepto
    inner join _srh_tipo_concepto T ON C.id_tipo_concepto = T.id_tipo_concepto
    left join _srh_concepto_remunerativo B ON C.agrupa_boleta = B.id_concepto
    where PD.id_planilla  = varPlanilla
    and PD.id_empresa     = varEmpresa
    and PD.id_trabajador  = varTrabajador
    GROUP BY T.TIPO, 
    CASE WHEN IFNULL(C.agrupa_boleta,'')<>''
        THEN C.agrupa_boleta
        ELSE PD.id_concepto 
    END, 
    CASE WHEN IFNULL(C.agrupa_boleta,'')<>''
        THEN B.nombre
        ELSE C.nombre
    END
    UNION
    select 'D' as TIPO, '0701' as CCON, 'ADELANTO' as CONCEPTO, 
    SUM(PA.monto) AS MONTO
    from _srh_planilla_adelanto PA
    where PA.id_planilla  = varPlanilla
    and PA.id_empresa     = varEmpresa
    and PA.id_trabajador  = varTrabajador
    ) A
  where TIPO = varTipo
  ORDER BY TIPO, CCON;
END;