CALL spQuery_Asignacion_Documentos_Detalle(1);

DROP PROCEDURE IF EXISTS spQuery_Asignacion_Documentos_Detalle;
CREATE PROCEDURE spQuery_Asignacion_Documentos_Detalle(
  varAsignacion int
  )
BEGIN
  select V.id_venta as IDE,
  CONCAT(T.abrev,'/',V.nro_serie, '-', V.nro_preimpreso) AS NDOC,
  CAST(SUBSTRING(CONCAT(V.id_cliente,' - ',C.nombre),1,35) AS CHAR) as CLIENTE, SUBSTRING(C.DIRECCION,1,35) AS DIRECCION,
  CONCAT(V.id_ruta,' - ', R.nombre) as RUTA,
  V.id_trabajador as VENDEDOR,
  V.TOTAL,
  V.SALDO
  from _sv_asignacion_venta A
  inner join _sv_venta V on A.id_venta = V.id_venta
  inner join _sv_cliente C ON V.id_cliente = C.id_cliente
  inner join _sv_ruta R ON V.id_ruta = R.id_ruta
  inner join _sv_tipo_doc_venta T ON V.id_tipo_doc = T.id_tipo_doc
  where V._estado = 'A'
  AND V.estado <> 'AN'
  and A.id_asignacion = varAsignacion;
END;