CALL spQuery_Asignacion(1,null,null,null,null,null,null);

DROP PROCEDURE IF EXISTS spQuery_Asignacion;
CREATE PROCEDURE spQuery_Asignacion(
  varAsignacion int,
	varVehiculo   int,
  varConductor  int,
  varFechaIni   date,
  varFechaFin   date,
  varField      varchar(60),
  varOrder      varchar(5)
  )
BEGIN  
  DECLARE varCadCod, varCadVeh, varCadCon, varCadIni, varCadFin text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
   
  if varAsignacion<>'' or varAsignacion is not null then
    set varcadCod = CONCAT(" and A.id_asignacion = ",varAsignacion, " ");
  end if;
  if varVehiculo<>'' or varVehiculo is not null then
    set varCadVeh = CONCAT(" and A.id_vehiculo = ",varVehiculo, " ");
  end if;
  if varConductor<>'' or varConductor is not null then
    set varCadCon = CONCAT(" and A.id_trabajador = ",varConductor, " ");
  end if;
  if varFechaIni<>'' or varFechaIni is not null then
    set varCadIni = CONCAT(" and A.id_fecha >= '",varFechaIni, "' ");
  end if;
  if varFechaFin<>'' or varFechaFin is not null then
    set varCadFin = CONCAT(" and A.id_fecha <= '",varFechaFin, "' ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  ELSE
    SET varCadOrd = CONCAT("ORDER BY A.id_asignacion ");
  END IF;
  
  set @sql = CONCAT("select A.id_asignacion as ASIG, ",
                    "date_format(A.id_fecha,'%d/%m/%Y') as FECHA, ",
                    "A.id_vehiculo as CVEH, V.PLACA, V.descripcion AS VEHICULO, ",
                    "A.id_conductor as CCON, concat(C.apellido_paterno, ' ', C.apellido_materno, ' ', C.nombre) as CONDUCTOR, ",
                    "(select count(id_venta) from _sv_asignacion_venta V where V.id_asignacion = A.id_asignacion and V._estado='A') as NUM_DOC, ",
                    "(select SUM(IFNULL(V.monto_ped,0)) from _sv_asignacion_venta V where V.id_asignacion = A.id_asignacion and V._estado='A') as MON_DOC, ",
                    "date_format(A._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(A._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_asignacion A ",                    
                    "inner join _sv_vehiculo V ON A.id_vehiculo = V.id_vehiculo ",
                    "inner join _sv_trabajador C ON A.id_conductor = C.id_trabajador ",
                    "left join _sys_usuario UN ON A._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON A._user_update = UU.id_usuario ",
                    "where A._estado = 'A' ", 
                    varcadCod, varCadVeh, varCadCon, varCadIni, varCadFin,
                    varCadOrd,
                    ";");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;