select * from _sind_menu 


call spMenu_General('01',24)

DROP PROCEDURE IF EXISTS spMenu_General;
CREATE PROCEDURE spMenu_General(
	varPadre varchar(10),
	varUsuario int
)
BEGIN
	declare varTamano int;
	if varPadre='root' then
		set varTamano = 2;
		select A.id_menu, A.nombre, A.img_out
		from (
			select * from _sind_menu where length(id_menu)=varTamano
			) A
		left join	
			(
			select id_menu from _sind_menu where length(id_menu)>varTamano
			) B
		on A.id_menu = SUBSTRING(B.id_menu, 1, varTamano)
		left join
			(
			select id_menu from _sind_menu_usuario 
			where id_usuario = varUsuario and length(id_menu)>varTamano
			) C
		on A.id_menu = SUBSTRING(C.id_menu, 1, varTamano)
		group by A.id_menu, A.nombre, A.img_out
		having count(distinct B.id_menu) > count(distinct C.id_menu);
	else
		set varTamano = length(varPadre)+2;
		select A.id_menu, A.nombre, A.img_out
		from (
			select * from _sind_menu where length(id_menu)=varTamano
			and substring(id_menu,1,varTamano-2)=varPadre
			) A
		left join	
			(
			select id_menu from _sind_menu where length(id_menu)>varTamano
			) B
		on A.id_menu = SUBSTRING(B.id_menu, 1, varTamano)
		left join
			(
			select id_menu from _sind_menu_usuario 
			where id_usuario = varUsuario and length(id_menu)>varTamano
			) C
		on A.id_menu = SUBSTRING(C.id_menu, 1, varTamano)
		group by A.id_menu
		having count(distinct B.id_menu) > count(distinct C.id_menu)
		union
		select id_menu, nombre, img_out from _sind_menu where length(id_menu)=varTamano
		and substring(id_menu,1,varTamano-2)=varPadre
		and id_menu not in 
		(select id_menu from _sind_menu_usuario 
		where id_usuario = varUsuario and length(id_menu)=varTamano
		and substring(id_menu,1,varTamano-2)=varPadre)
		order by id_menu;
	end if;
END