/* SISGESINT */
call spMante_Venta_Anular(1, 1);

DROP PROCEDURE IF EXISTS spMante_Venta_Anular;
CREATE PROCEDURE spMante_Venta_Anular(
  varEmpresa  int,
	varNumVenta bigint,
  varUsuario  int
  )
BEGIN 
  DECLARE varExiste, varAlmacen int;
  DECLARE varCantidad   double;
  DECLARE varProducto   varchar(6);
  DECLARE varMovimiento varchar(5);
  
  DECLARE done INT DEFAULT 0;
  DECLARE curDetDoc CURSOR FOR 
		      select D.id_producto, D.cantidad, D.id_movimiento, V.id_almacen
          from _sv_venta_detalle D
          inner join _sv_venta V ON  D.id_venta = V.id_venta
          where V.id_empresa  = varEmpresa
          and D.id_venta      = varNumVenta;
  
	DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
  
  select count(id_venta) into varExiste 
  from _sv_venta 
  where id_venta  = varNumVenta 
  and estado     <> 'AN'
  and id_empresa  = varEmpresa;
  
  if varExiste > 0 then
    /*Cambiamos a Estado ANULADO=AN el Documento Seleccionado*/
    update _sv_venta 
    set estado    = 'AN', 
    subtotal      = 0, 
    igv           = 0, 
    total         = 0, 
    saldo         = 0,  
    _date_update  = NOW(), 
    _user_update  = varUsuario 
    where id_venta= varNumVenta
    and id_empresa= varEmpresa;    
    
    /*ELIMINAMOS LOS MOVIMIENTOS DE LA CUENTA CORRIENTE DEL CLIENTE*/
    update _sv_movimiento_cuenta_cxc
    set _estado     = 'X', 
    _date_update    = NOW(), 
    _user_update    = varUsuario 
    where id_venta  = varNumVenta
    and id_empresa  = varEmpresa;
    
    /*ELIMINAMOS LOS PAGOS DE LA TABLA PAGO*/
    update _sv_pago_cxc
    set _estado   = 'X',
    _date_update  = NOW(), 
    _user_update  = varUsuario
    where id_venta= varNumVenta
    and id_empresa= varEmpresa;
    
    /* Recorremos los Articulos que contiene el Documento a Anular */
    OPEN curDetDoc;
    REPEAT
      FETCH curDetDoc INTO varProducto, varCantidad, varMovimiento, varAlmacen;
      IF NOT done THEN
        /*ACTUALIZAMOS EL STOCK DEL PRODUCTO EN EL ALMACEN QUE CORRESPONDE*/
        update _sv_kardex 
        SET cantidad     = cantidad + varCantidad,
        _date_update     = NOW(),
        _user_update     = varUsuario
        where id_almacen = varAlmacen
        and id_empresa   = varEmpresa
        and id_producto  = varProducto;        
        
        /*Anulamos los Movimientos en el Almacen generados en la Venta*/
        update _sv_movimiento_almacen 
        set _estado         = 'X', 
        _date_update        = NOW(),
        _user_update        = varUsuario 
        where id_referencia = varNumVenta
        and id_empresa      = varEmpresa
        and id_almacen      = varAlmacen
        and id_movimiento   = varMovimiento;
    
      END IF;
      UNTIL done END REPEAT;
    CLOSE curDetDoc;
    SELECT 'OK';
  else
    SELECT 'NO SE PUEDE ANULAR ESTE REGISTRO, PORQUE YA SE ENCUENTRA ANULADO...';
  end if;
END;