SELECT * FROm _sv_kardex where id_producto in ('110007','110020');
SELECT * FROm _sv_movimiento_almacen where id_producto in ('110007','110020') and id_movimiento in ('104','204');



call spMante_Trasferencia_Bonif('110007','110020',240);


DROP PROCEDURE IF EXISTS spMante_Trasferencia_Bonif;
CREATE PROCEDURE spMante_Trasferencia_Bonif(
	varCodOrig  varchar(6),
	varCodDest  varchar(6),
  varFechaMov date,
	varCantidad int,
  varUsuario  int
)
BEGIN
  DECLARE varNumMov bigint;
  
  DECLARE varExiste int default 0;
  
  -- Salida por Transferencia 104 del producto Original
  SET varNumMov = (select max(id_mov_almacen)+1 from _sv_movimiento_almacen);
  insert into _sv_movimiento_almacen values(varNumMov, '204', 1, 1, NULL, varCodOrig, varCantidad, varFechaMov, 
                                            NOW(), NOW(), varUsuario, varUsuario, 'A');

  -- Ingreso por Transferencia 204 del producto Destino
  SET varNumMov = (select max(id_mov_almacen)+1 from _sv_movimiento_almacen);
  insert into _sv_movimiento_almacen values(varNumMov, '104', 1, 1, NULL, varCodDest, varCantidad, varFechaMov, 
                                            NOW(), NOW(), varUsuario, varUsuario, 'A');

  -- Actualizamos STOCK del Producto Original
  update _sv_kardex 
  set cantidad = cantidad - varCantidad,
  _user_update = varUsuario,
  _date_update = NOW()
  where id_producto = varCodOrig;

  -- Actualizamos STOCK del Producto Destino
  select count(*) into varExiste from _sv_kardex where id_producto = varCodDest;
  if varExiste > 0 then
    update _sv_kardex 
    set cantidad = cantidad + varCantidad,
    _user_update = varUsuario,
    _date_update = NOW()
    where id_producto = varCodDest;
  else
    insert into _sv_kardex values(1, 1, varCodDest, varCantidad, NOW(), NOW(), varUsuario, varUsuario, 'A');
  end if;
END;