call spMante_Pedido_Det(7, '130012', 1, 100, 4.02074, 'UND', 1);
call spMante_Pedido_Det(7, '130013', 1, 100, 0.40833, 'UND', 1);

DROP PROCEDURE IF EXISTS spMante_Pedido_Det;
CREATE PROCEDURE spMante_Pedido_Det(  
	varNum        int, 
	varArticulo   varchar(6),   
	varCantidad   double,
  varUnitario   double,
  varUnidMed    varchar(10), 
  varUsuario    int
  )
BEGIN  
  DECLARE varTotal, varSubTotal, varIgv double;  
  
  -- Calculamos los Montos por Producto
  SET varTotal      = round(varCantidad*varUnitario,2);
  SET varIgv        = round(varTotal - varTotal/1.18,2);
  SET varSubTotal   = round(varTotal/1.18,2);
    
  /* Registramos Detalle del Pedido */
	insert into _sv_pedido_detalle(id_pedido, id_producto, id_um, cantidad_ped, cantidad_ate, precio, subtotal, igv, total, _date_create, _date_update, _user_create, _user_update) 
  values (varNum, varArticulo, varUnidMed, varCantidad, varCantidad, varUnitario, varSubTotal, varIgv, varTotal, NOW(), NOW(), varUsuario, varUsuario);
END;