call spMante_Pedido_Cambio_Cab(1, 1, 5669, 8, 1, 31, NULL, NULL, 442.9, 1);
call spMante_Pedido_Cambio_Cab('NEW', NULL, 1, 5, NULL, 1, 'GEN', 1, 1, NULL, NULL,0, 1);

DROP PROCEDURE IF EXISTS spMante_Pedido_Cambio_Cab;
CREATE PROCEDURE spMante_Pedido_Cambio_Cab(
  varOpcion     varchar(10),
  varPedido     int,
  varEmpresa    int,
  varAgencia    int,
  varAlmacen    int,
  varTipoDoc    int,
	varCondicion  int,  
  varCliente    int,
  varRuta       varchar(10),
  varLista      int,
  varVendedor   int,
  varNotaPedido varchar(20),
  varGlosa      text,
	varTotal      double,
  varUsuario    int
  )
BEGIN  
  DECLARE varSubTotal, varIgv double;
  
  SET varSubTotal = round(varTotal/1.18,2);
  SET varIgv      = round(varTotal - varTotal/1.18,2);
  
  if varOpcion = 'NEW' then
	  SELECT if(isnull(MAX(id_pedido)),0,MAX(id_pedido))+1 INTO varPedido FROM _sv_pedido;  
    insert into _sv_pedido (id_pedido, id_empresa, id_agencia, id_almacen, id_cliente, id_trabajador, id_lista, id_ruta, fecha_pedido, id_tipo_doc, id_condicion, nro_pedido, glosa, 
                            estado, subtotal, igv, total, _date_create, _date_update, _user_create, _user_update)
    VALUES (varPedido, varEmpresa, varAgencia, varAlmacen, varCliente, varVendedor, varLista, varRuta, NOW(), varTipoDoc, varCondicion, 
            varNotaPedido, varGlosa, 'IN', varSubTotal, varIgv, varTotal, NOW(), NOW(), varUsuario, varUsuario);                     
  else
    -- Actualizamos la Cabecera del Pedido
    update _sv_pedido
    set id_empresa  = varEmpresa, 
    id_almacen    = varAlmacen,
    id_agencia    = varAgencia,
    id_cliente    = varCliente, 
    id_trabajador = varVendedor, 
    id_lista      = varLista, 
    id_ruta       = varRuta, 
    id_tipo_doc   = varTipoDoc, 
    id_condicion  = varCondicion, 
    nro_pedido    = varNotaPedido, 
    glosa         = varGlosa, 
    subtotal      = varSubTotal, 
    igv           = varIgv, 
    total         = varTotal,
    _date_update  = NOW(),
    _user_update  = varUsuario
    where id_pedido = varPedido;
    -- Eliminamos el Detalle del Pedido para que vuelva a ser insertado
    delete from _sv_pedido_detalle where id_pedido = varPedido;
  end if; 
  SELECT varPedido;
END;