call spMante_Pedido(1571, '2012-01-16', 1);

DROP PROCEDURE IF EXISTS spMante_Pedido;
CREATE PROCEDURE spMante_Pedido(
  varPedido     bigint,
  varFecha      date,
  varUsuario    int  
  )
BEGIN  
	DECLARE varNumVen, varNumPago bigint;
  DECLARE varLoc, varTipoDoc, varCon, varCli, varLis, varVen, varVerifSotck int;
  DECLARE varRut, varNumDoc varchar(20);
  DECLARE varGlo      text;
  DECLARE varTipo     char(3);
  DECLARE varFVen     date;
  DECLARE varTot, varSub, varIgv double;
  /* Cursor para Consultar detalle del Pedido */
  DECLARE varArticulo, varUM varchar(10);
  DECLARE varCantidad, varPrecio double;
  DECLARE varTipoDet  char(1);
  
  
  DECLARE done INT DEFAULT 0;
	DECLARE cur1 CURSOR FOR 
			select id_producto, cantidad_ped, precio, id_um, id_tipo
      from _sv_pedido_detalle
      where id_pedido = varPedido
      and id_tipo <> 'B';
	DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
  
  /*Verificamos que al menos un producto tenga stock*/
  select sum(ifnull(cantidad,0)) INTO varVerifSotck
  from
    (
    select id_producto, cantidad_ped
    from _sv_pedido_detalle
    where id_pedido = varPedido
    ) A
  left join
    (
    select id_producto, cantidad
    from _sv_kardex
    where id_almacen=1
    ) B
  on A.id_producto = B.id_producto;

  select id_local, ifnull(id_tipo_doc,3) as id_tipo_doc, id_condicion, id_cliente, id_ruta, id_lista, id_vendedor, glosa, total
  into varLoc, varTipoDoc, varCon, varCli, varRut, varLis, varVen, varGlo, varTot
  from _sv_pedido
  where estado = 'IN'
  AND id_pedido = varPedido;
  
  if varLoc IS NOT NULL and varVerifSotck > 0 then
    SELECT if(isnull(MAX(id_venta)),0,MAX(id_venta))+1 INTO varNumVen FROM _sv_venta;  
    
    SELECT tipo, DATE_ADD(NOW(), INTERVAL dias DAY) INTO varTipo, varFVen FROM _sv_tipo_condicion WHERE id_condicion = varCon;  
    
    SET varNumDoc = spFuncion_NumeroDocumento(varTipoDoc);
    SET varSub    = round(varTot/1.18,2);
    SET varIgv    = round(varTot - varTot/1.18,2);
    
    /*Registramos Cabecera de la Venta*/	  
    insert into _sv_venta (id_venta, id_local, id_cliente, id_vendedor, id_ruta, id_lista, 
                           fecha_emision, fecha_vencimiento, id_tipo_doc, nro_documento, id_condicion,
                           nro_pedido, glosa, estado, subtotal, igv, total, saldo, 
                           _date_create, _date_update, _user_create, _user_update)
    VALUES (varNumVen, varLoc, varCli, varVen, varRut, varLis, varFecha, varFVen, 
            varTipoDoc, varNumDoc, varCon, varPedido, varGlo, 
            'AC', varSub, varIgv, varTot, varTot, NOW(), NOW(), varUsuario, varUsuario);                     
    
    /*ACTUALIZAMOS FECHA DE LA ULTIMA COMPRA */
    update _sv_cliente set ultima_compra=varFecha where id_cliente=varCli;
    
    /*REGISTRAMOS LA VENTA EN MOVIMIENTO CUENTA */  
    insert into _sv_movimiento_cuenta_cxc(id_cliente, id_venta, id_pago_cxc, tipo_mov, fecha, monto, _date_create, _date_update, _user_create, _user_update)
    values (varCli, varNumVen, NULL, 'VEN', varFecha, varTot, NOW(), NOW(), varUsuario, varUsuario);
    
    
    /*SI ES CONTADO REGISTRAMOS EL PAGO EN EL MOVIMIENTO CUENTA*/
    
    if varTipo='CO' then   
      SELECT if(isnull(MAX(id_pago_cxc)),0,MAX(id_pago_cxc))+1 INTO varNumPago FROM _sv_pago_cxc; 
      
      insert into _sv_pago_cxc(id_pago_cxc, id_empresa, id_cliente, id_venta, id_forma_pago, nro_doc_pago, fecha, monto, observacion, _date_create, _date_update, _user_create, _user_update)
      values(varNumPago, varEmpresa, varCliente, varNumVenta, 1, '00001', varFecha, varTotal, 'Pago al Contado', NOW(), NOW(), varUsuario, varUsuario);
      
      insert into _sv_movimiento_cuenta_cxc(id_cliente, id_venta, id_pago_cxc, tipo_mov, fecha, monto, _date_create, _date_update, _user_create, _user_update)
      values(varCli, varNumVen, NULL, 'PAG', varFecha, varTot, NOW(), NOW(), varUsuario, varUsuario);     
      update _sv_venta set estado='CA', saldo=0 where id_venta = varNumVen;
    end if;
    /*ACTUALIZAMOS EL CORRELATIVO DEL TIPO DE DOCUMENTO*/  
    UPDATE _sv_tipo_doc_venta
    SET secuencia = secuencia + 1
    where id_tipo_doc = varTipoDoc;
    
    /*ACTUALIZAMOS EL ESTADO DEL PEDIDO*/
    update _sv_pedido
    set estado = 'FA',
    _date_update = NOW(),
    _user_update = varUsuario
    where id_pedido = varPedido;
    
-- SELECT varNumVen;
    
    /*RECORREMOS EL CONTENIDO DEL DETALLE DEL PEDIDO PARA INSERTARLO EN EL DETALLE DE LA VENTA*/
    OPEN cur1;
    REPEAT
      FETCH cur1 INTO varArticulo, varCantidad, varPrecio, varUM, varTipoDet;
      IF NOT done THEN      
          call spMante_Venta_Det(varNumVen, varArticulo, varLoc, varCantidad, varPrecio, varUM, varTipoDet, varFecha, varUsuario);
      END IF;
      UNTIL done END REPEAT;
    CLOSE cur1;
    call spMante_Venta_Update(varNumVen);
    -- Aplicar Bonificacion
    call spMante_Bonificacion_Facturar(varNumVen, varLoc, varCli,  varRut, varLis, varFecha, varUsuario);
  else
    select 'YA ESTA FACTURADO';
  end if;
END;