call spMante_Movimiento_Almacen('NEW', NULL, 'ingreso por deuda', 'ING', 1);

DROP PROCEDURE IF EXISTS spMante_Movimiento_Almacen;
CREATE PROCEDURE spMante_Movimiento_Almacen(
	varOpcion   varchar(10),
  varCodigo   varchar(5),
  varNombre   varchar(80),
	varTipo     char(3),
	varUsuario  int
)
BEGIN
  declare varLinkMenu varchar(10);
  
	if varOpcion='NEW' then
    SELECT CONCAT('1',CAST(LPAD(ifnull(max(substring(id_movimiento,2,2)),0)+1,2,'0') AS CHAR)) 
    INTO varCodigo 
    FROM _sys_tipo_movimiento
    WHERE tipo = varTipo;
    
    INSERT INTO _sys_tipo_movimiento (id_movimiento, descripcion, tipo, _date_create, _date_update, _user_create, _user_update) 
		values (varCodigo, UPPER(varNombre), varTipo, NOW(), NOW(), varUsuario, varUsuario);
	else
		update _sys_tipo_movimiento set
		descripcion   = UPPER(varNombre),
		tipo          = varTipo,
    _date_update  = NOW(),
		_user_update  = varUsuario
		where id_movimiento = varCodigo;
	end if;
END;