call spMante_Matriz_IP_Cierre(201302,1);
select * from _sv_trabajador where id_trabajador=16515280;

select * from _sind_logro where id_periodo_pago=201302 and id_trabajador=16515280;

DROP PROCEDURE IF EXISTS spMante_Matriz_IP_Cierre;
CREATE PROCEDURE spMante_Matriz_IP_Cierre(
  varPeriodo      int,
	varUsuario      int
  )
BEGIN
  delete from _sind_cierre where id_periodo = varPeriodo;
  
  insert into _sind_cierre
  select CPER, CTRA, CIND, CEMP, CAGE, meta, valor, logro, monto, sum(gana) as GANA, 
  now(), now(), varUsuario, varUsuario, 'A'
  from 
    ( 
    select PT.id_trabajador as CTRA, 
    concat(ifnull(apellido_paterno,''),' ', ifnull(apellido_materno,''),' ', ifnull(T.nombre,'')) as TRABAJADOR, 
    PT.id_matriz as CMAT, P.nombre as MATRIZ, 
    PT.id_periodo_pago as CPER, PP.nombre as PERIODO,
    PT.id_empresa as CEMP,
    PT.id_agencia as CAGE,
    PT.BASE, 
    T.id_cargo as CCAR, C.nombre as CARGO 
    from _sind_matriz_trabajador PT 
    inner join _sind_matriz P ON PT.id_matriz = P.id_matriz 
    inner join _srh_periodo_pago PP ON PT.id_periodo_pago = PP.id_periodo_pago 
    inner join _sv_trabajador T ON PT.id_trabajador = T.id_trabajador 
    left join _srh_cargo C ON PT.id_cargo = C.id_cargo 
    where PT.id_periodo_pago =  varPeriodo
    ) T 
  left join 
    ( 
    select CIND, id_trabajador, meta, valor, logro, monto, 
    case when Ind.id_tabla <> 0 
        then case when logro >= 100 
                  then case when id_um = 1 then case when logro <= 120 then monto*logro/100 else monto*120/100 end else monto end 
                  else case when id_um = 1 
                        then case when monto*(logro + formula)/100 <=0 
                                  then 0 
                                else monto*(logro + formula)/100 
                            end 
                        else monto*formula/100 
                    end 
            end 
        else gana 
    end as gana 
    from 
      ( 
      select I.CIND, I.simbolo, I.valcond, I.monto, I.id_tabla, S.id_trabajador, 
      S.meta, S.valor, S.logro, 
      case when I.simbolo='<' and S.logro < I.valcond then monto 
          when I.simbolo='<=' and S.logro <= I.valcond then monto 
          when I.simbolo='>' and S.logro > I.valcond then monto 
          when I.simbolo='>=' and S.logro >= I.valcond then monto 
          when I.simbolo='=' and S.logro = I.valcond then monto 
          else 0 
      end as gana, 
      id_um 
      from 
        ( 
        SELECT distinct PS.id_indicador as CIND, PS.id_condicion, C.simbolo, valcond, monto, I.id_tabla, I.id_um, PS.id_matriz 
        FROM _sind_matriz_periodo PS 
        inner join _sind_condicion C ON PS.id_condicion = C.id_condicion 
        inner join _sind_indicador I ON PS.id_indicador = I.id_indicador 
        where PS.tiponodo = 1 
        and PS.id_periodo_pago = varPeriodo
        ) I 
      left join 
        ( 
        select S.id_indicador as CIND, S.id_trabajador, S.meta, S.valor, PT.id_matriz, 
        round(S.valor/S.meta*100,2) as logro, S.comentario 
        from _sind_logro S, _sind_matriz_trabajador PT 
        where S.id_periodo_pago = PT.id_periodo_pago 
        and S.id_trabajador = PT.id_trabajador 
        and S.id_periodo_pago =  201302
        ) S 
      on I.CIND = S.CIND and I.id_matriz = S.id_matriz 
      )Ind 
    left join 
      ( 
      select id_tabla, rango_ini, rango_fin, formula 
      from _sind_tabla_detalle 
      ) T 
    on Ind.id_tabla = T.id_tabla 
    and Ind.logro >= T.rango_ini 
    and Ind.logro <= T.rango_fin 
    where id_trabajador is not null  
    ) S 
  on T.CTRA = S.id_trabajador 
  where CIND is not null
  group by  CPER, CTRA, CIND, CEMP, CAGE, meta, valor, logro, monto;
END;