call spMante_Inventario_Det(1, '2013-03-11', '010004', 'UND', 10, 1);

DROP PROCEDURE IF EXISTS spMante_Inventario_Det;
CREATE PROCEDURE spMante_Inventario_Det(
	varCodigo     int,
  varEmpresa    int,
  varAlmacen    int,
  varFecha      date,
  varProducto   varchar(10),
  varUM         varchar(10),	
  varCanFisico  double,
  varUsuario    int
)
BEGIN
  DECLARE varMov varchar(10);
  DECLARE varCanSistema, varCanDifer, varPrecio, varMonto DOUBLE;
  
  SET varCanSistema = (select cantidad 
                       from _sv_kardex 
                       where _estado='A' 
                       and id_empresa   = varEmpresa
                       and id_almacen   = varAlmacen 
                       and id_producto  = varProducto);
  
  SET varCanDifer = varCanFisico - ifnull(varCanSistema,0);
  
  SET varPrecio = (select min(precio) as precio 
                   from _sv_lista_producto 
                   where _estado='A' 
                   and id_empresa   = varEmpresa
                   and id_producto  = varProducto
                   and id_um        = varUM);
  
  SET varMonto = varCanDifer*IFNULL(varPrecio,0);
  
  -- Insertamos Detalle del Inventario
  INSERT INTO _sv_inventario_det (id_inventario, id_producto, id_um, cant_sistema, cant_fisico, cant_diferencia, precio, monto, 
                                  _date_create, _date_update, _user_create, _user_update)
  VALUES (varCodigo, varProducto, varUM, varCanSistema, varCanFisico, varCanDifer, varPrecio, varMonto,
         NOW(),NOW(), varUsuario, varUsuario);
	
  IF varCanFisico<>varCanSistema THEN
    IF varCanFisico > varCanSistema THEN
      set varMov = '103';
    ELSE
      set varMov = '203';
    END IF;
    -- Insertamos el Movimiento en el Almacen
    insert into _sv_movimiento_almacen(id_movimiento, id_empresa, id_almacen, id_referencia, id_producto, cantidad, fecha, _date_create, _date_update, _user_create, _user_update)
    values(varMov, varEmpresa, varAlmacen, NULL, varProducto, ABS(varCanDifer), varFecha, NOW(), NOW(), varUsuario, varUsuario); 
    
    /* Actualizamos el KARDEX */
    update _sv_kardex 
    SET cantidad = cantidad + varCanDifer,
    _date_update = NOW(),
    _user_update = varUsuario
    where id_empresa  = varEmpresa
    and id_almacen    = varAlmacen
    and id_producto   = varProducto;
  END IF;
END;