call spMante_Facturar_Cambios(1571, '2012-01-16', 1);

DROP PROCEDURE IF EXISTS spMante_Facturar_Cambios;
CREATE PROCEDURE spMante_Facturar_Cambios(
  varPedido     bigint,
  varPuntoVenta int,
  varSerieCam   int,
  varFecha      date,
  varUsuario    int 
  )
BEGIN  
	declare varNumVen bigint;
  declare varLoc, varTipoDoc, varCon, varCli, varLis, varVen, varVerifSotck int;
  declare varRut, varNumDoc varchar(20);
  declare varGlo            text;
  /* Cursor para Consultar detalle del Pedido */
  DECLARE varArticulo, varUM      varchar(10);
  DECLARE varCantidad double;
  DECLARE varTipoDet  char(1);
  DECLARE varLote     varchar(20);
  DECLARE varFechaV   date;
    
  DECLARE done INT DEFAULT 0;
	DECLARE cur1 CURSOR FOR 
			select id_producto, cantidad_ped, id_um, id_tipo, lote, fecha_vencimiento
      from _sv_pedido_detalle
      where id_pedido = varPedido
      and id_tipo <> 'B';
	DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
  
  /*Verificamos que al menos un producto tenga stock*/
  select sum(ifnull(cantidad,0)) INTO varVerifSotck
  from
    (
    select id_producto, cantidad_ped
    from _sv_pedido_detalle
    where id_pedido = varPedido
    ) A
  left join
    (
    select id_producto, cantidad
    from _sv_kardex
    where id_almacen=1
    ) B
  on A.id_producto = B.id_producto;

  select id_local, ifnull(id_tipo_doc,3) as id_tipo_doc, id_condicion, id_cliente, id_ruta, id_lista, id_vendedor, glosa
  into varLoc, varTipoDoc, varCon, varCli, varRut, varLis, varVen, varGlo
  from _sv_pedido
  where estado = 'IN'
  AND id_pedido = varPedido;
  
  if varLoc IS NOT NULL and varVerifSotck > 0 then
    SELECT if(isnull(MAX(id_venta)),0,MAX(id_venta))+1 INTO varNumVen FROM _sv_venta;    
    SET varNumDoc = spFuncion_NumeroDocumento(varTipoDoc);
    
    /*Registramos Cabecera de la Venta*/	  
    insert into _sv_venta (id_venta, id_local, id_cliente, id_vendedor, id_ruta, id_lista, fecha_emision, id_tipo_doc, nro_documento, id_condicion,
                          nro_pedido, glosa, estado, subtotal, igv, total, saldo, _date_create, _date_update, _user_create, _user_update)
    VALUES (varNumVen, varLoc, varCli, varVen, varRut, varLis, varFecha, varTipoDoc, varNumDoc, varCon, varPedido, varGlo, 
          'AC', 0, 0, 0, 0, NOW(), NOW(), varUsuario, varUsuario);                     
    
    
    /*ACTUALIZAMOS EL CORRELATIVO DEL TIPO DE DOCUMENTO*/  
    UPDATE _sv_tipo_doc_venta
    SET secuencia = secuencia + 1
    where id_tipo_doc = varTipoDoc;
    
    /*ACTUALIZAMOS EL ESTADO DEL PEDIDO*/
    update _sv_pedido
    set estado = 'FA',
    _date_update = NOW(),
    _user_update = varUsuario
    where id_pedido = varPedido;
    
    /*RECORREMOS EL CONTENIDO DEL DETALLE DEL PEDIDO PARA INSERTARLO EN EL DETALLE DE LA VENTA*/
    OPEN cur1;
    REPEAT
      FETCH cur1 INTO varArticulo, varCantidad, varUM, varTipoDet, varLote, varFechaV;
      IF NOT done THEN      
          call spMante_Cambio_Det(varNumVen, varArticulo, varLoc, varCantidad, varUM, varLote, varFechaV, varFecha, varUsuario);
      END IF;
      UNTIL done END REPEAT;
    CLOSE cur1;
    
  else
    select 'YA ESTA FACTURADO';
  end if;
END;